<?php
session_start();
require '../../edu_digital/config/database.php';

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    header("Location: ../tagihan.php");
    exit;
}

$mode = $_POST['mode'] ?? '';
$siswa_id = $_POST['siswa_id'] ?? '';
$kelas_id = $_POST['kelas_id'] ?? '';
$bulan = $_POST['bulan'] ?? '';
$nominal = $_POST['nominal'] ?? 0;
$tahun_ajaran_id = $_POST['tahun_ajaran_id'] ?? '';

if(!$nominal || !$tahun_ajaran_id){
    die("Data tidak lengkap.");
}

$nominal = intval($nominal);

$daftar_bulan = [
"Januari","Februari","Maret","April","Mei","Juni",
"Juli","Agustus","September","Oktober","November","Desember"
];

function insertTagihan($conn,$siswa,$bulan,$nominal,$tahun){

    $stmt = $conn->prepare("
        INSERT INTO spp_tagihan
        (siswa_id, tahun_ajaran_id, bulan, nominal, status)
        VALUES (?,?,?,?, 'belum')
        ON DUPLICATE KEY UPDATE nominal=VALUES(nominal)
    ");
    $stmt->bind_param("iisi",$siswa,$tahun,$bulan,$nominal);
    $stmt->execute();
}

if($mode == "siswa"){

    if(!$siswa_id){
        die("Siswa belum dipilih.");
    }

    if($bulan == "ALL"){
        foreach($daftar_bulan as $b){
            insertTagihan($conn,$siswa_id,$b,$nominal,$tahun_ajaran_id);
        }
    }else{
        insertTagihan($conn,$siswa_id,$bulan,$nominal,$tahun_ajaran_id);
    }

}
elseif($mode == "kelas"){

    if(!$kelas_id){
        die("Kelas belum dipilih.");
    }

    $getSiswa = $conn->prepare("SELECT id FROM siswa WHERE kelas_id=?");
    $getSiswa->bind_param("i",$kelas_id);
    $getSiswa->execute();
    $result = $getSiswa->get_result();

    while($s = $result->fetch_assoc()){

        if($bulan == "ALL"){
            foreach($daftar_bulan as $b){
                insertTagihan($conn,$s['id'],$b,$nominal,$tahun_ajaran_id);
            }
        }else{
            insertTagihan($conn,$s['id'],$bulan,$nominal,$tahun_ajaran_id);
        }
    }
}

header("Location: /pkbm-test/spp/tagihan.php");
exit;

