CREATE TABLE spp_tagihan (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT NOT NULL,
    tahun_ajaran_id INT NOT NULL,
    bulan ENUM(
        'Januari','Februari','Maret','April','Mei','Juni',
        'Juli','Agustus','September','Oktober','November','Desember'
    ) NOT NULL,
    nominal INT NOT NULL,
    status ENUM('belum','lunas') NOT NULL DEFAULT 'belum',
    jatuh_tempo DATE DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    UNIQUE KEY unik_spp (siswa_id, tahun_ajaran_id, bulan),

    CONSTRAINT fk_spp_tagihan_siswa
        FOREIGN KEY (siswa_id) REFERENCES siswa(id)
        ON DELETE CASCADE ON UPDATE CASCADE,

    CONSTRAINT fk_spp_tagihan_tahun
        FOREIGN KEY (tahun_ajaran_id) REFERENCES tahun_ajaran(id)
        ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE spp_pembayaran (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tagihan_id INT NOT NULL,
    siswa_id INT NOT NULL,
    tanggal_bayar DATE NOT NULL,
    jumlah_bayar DECIMAL(12,2) NOT NULL,
    metode ENUM('cash','transfer','qris') NOT NULL,
    bukti_transfer VARCHAR(255),
    diterima_oleh INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    CONSTRAINT fk_spp_bayar_tagihan
        FOREIGN KEY (tagihan_id) REFERENCES spp_tagihan(id)
        ON DELETE CASCADE ON UPDATE CASCADE,

    CONSTRAINT fk_spp_bayar_siswa
        FOREIGN KEY (siswa_id) REFERENCES siswa(id)
        ON DELETE CASCADE ON UPDATE CASCADE,

    CONSTRAINT fk_spp_bayar_user
        FOREIGN KEY (diterima_oleh) REFERENCES users(id)
        ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE spp_verifikasi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pembayaran_id INT NOT NULL,
    status ENUM('pending','diterima','ditolak') NOT NULL DEFAULT 'pending',
    catatan TEXT,
    diverifikasi_oleh INT,
    diverifikasi_pada DATETIME,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    UNIQUE KEY uniq_pembayaran (pembayaran_id),

    CONSTRAINT fk_spp_verifikasi_bayar
        FOREIGN KEY (pembayaran_id)
        REFERENCES spp_pembayaran(id)
        ON DELETE CASCADE ON UPDATE CASCADE,

    CONSTRAINT fk_spp_verifikasi_user
        FOREIGN KEY (diverifikasi_oleh)
        REFERENCES users(id)
        ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
