<?php
session_start();
require __DIR__ . '/../config/database.php';

header('Content-Type: application/json');

if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['ujian']['id_ujian']) ||
    empty($_SESSION['siswa']['id'])
) {
    http_response_code(403);
    echo json_encode(['status'=>'error','msg'=>'NOSESSION']);
    exit;
}

$id_ujian = (int)$_SESSION['ujian']['id_ujian'];
$id_siswa = (int)$_SESSION['siswa']['id'];
$ket      = trim($_POST['keterangan'] ?? 'Pelanggaran');

if(empty($_POST['image'])){
    echo json_encode(['status'=>'error','msg'=>'NOIMAGE']);
    exit;
}

/* ===== FOLDER ===== */
$dir = __DIR__."/../uploads/webcam/ujian_$id_ujian/";
if(!is_dir($dir)) mkdir($dir,0777,true);

/* ===== PROSES BASE64 ===== */
$img = str_replace('data:image/jpeg;base64,','',$_POST['image']);
$img = str_replace(' ','+',$img);
$data = base64_decode($img);

$nama = 'cam_'.$id_siswa.'_'.time().'.jpg';
file_put_contents($dir.$nama,$data);

/* ===== SIMPAN LOG ===== */
$stmt = $conn->prepare("
INSERT INTO webcam_log
(id_siswa,id_ujian,foto,keterangan,waktu)
VALUES (?,?,?,?,NOW())
");
$stmt->bind_param("iiss",$id_siswa,$id_ujian,$nama,$ket);
$stmt->execute();

echo json_encode(['status'=>'ok','file'=>$nama]);
