<?php
session_start();
require __DIR__ . '/../config/database.php';

header('Content-Type: application/json');

if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['ujian']['id_ujian']) ||
    empty($_SESSION['siswa']['id'])
) {
    http_response_code(403);
    echo json_encode(['status'=>'error','msg'=>'NOSESSION']);
    exit;
}

$id_ujian = (int)$_SESSION['ujian']['id_ujian'];
$id_siswa = (int)$_SESSION['siswa']['id'];
$jenis    = trim($_POST['jenis'] ?? 'Tidak diketahui');

if (!$id_ujian || !$id_siswa || $jenis=='') {
    echo json_encode(['status'=>'error','msg'=>'INVALID']);
    exit;
}

/* ===== SIMPAN PELANGGARAN ===== */
$stmt = $conn->prepare("
INSERT INTO pelanggaran_ujian
(id_siswa,id_ujian,jenis_pelanggaran,waktu)
VALUES (?,?,?,NOW())
");
$stmt->bind_param("iis",$id_siswa,$id_ujian,$jenis);
$stmt->execute();

/* ===== UPDATE LAST ACTIVE ===== */
$conn->query("
UPDATE login_siswa
SET last_active=NOW()
WHERE id_siswa=$id_siswa AND id_ujian=$id_ujian
");

echo json_encode(['status'=>'ok']);
