<?php
require __DIR__ . '/auth.php';
require __DIR__ . '/../config/database.php';

$id_siswa = $_SESSION['siswa']['id'];
$nama     = $_SESSION['siswa']['nama'];
$kelas    = $_SESSION['siswa']['kelas'];

$ujian = mysqli_query(
    $conn,
    "SELECT id, nama_ujian, durasi
     FROM ujian
     WHERE status='aktif'
     ORDER BY id DESC"
);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Siswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.card{border-radius:16px}
</style>
</head>
<body>

<div class="container py-4">

<h4 class="fw-bold">Dashboard Peserta Ujian</h4>
<small class="text-muted">
Selamat datang, <b><?= htmlspecialchars($nama) ?></b> | Kelas <?= htmlspecialchars($kelas) ?>
</small>

<div class="alert alert-info mt-3">
📌 Masukkan token ujian dengan benar sebelum memulai.
</div>

<div class="card shadow-sm mt-3">
<div class="card-body p-0">

<table class="table table-bordered mb-0">
<thead class="table-dark">
<tr>
  <th>Nama Ujian</th>
  <th>Durasi</th>
  <th width="140">Aksi</th>
</tr>
</thead>
<tbody>

<?php if(mysqli_num_rows($ujian)==0): ?>
<tr>
  <td colspan="3" class="text-center text-muted">
    Tidak ada ujian aktif
  </td>
</tr>
<?php endif; ?>

<?php while($u=mysqli_fetch_assoc($ujian)): ?>
<tr>
  <td><?= htmlspecialchars($u['nama_ujian']) ?></td>
  <td><?= (int)$u['durasi'] ?> menit</td>
  <td class="text-center">
    <a href="cek_token.php?id=<?= (int)$u['id'] ?>"
       class="btn btn-success btn-sm"
       onclick="return confirm('Mulai ujian sekarang?')">
       Mulai Ujian
    </a>
  </td>
</tr>
<?php endwhile; ?>

</tbody>
</table>

</div>
</div>

<div class="text-end mt-3">
<a href="../auth/logout.php" class="btn btn-outline-danger btn-sm">Logout</a>
</div>

</div>
</body>
</html>
