<?php
session_start();

/* =============================
   PROTEKSI STEP
============================= */
if (!isset($_SESSION['step']) || $_SESSION['step'] < 4) {
    header("Location: index.php");
    exit;
}

/* =============================
   BUAT INSTALL.LOCK
============================= */
$lockFile = __DIR__ . '/install.lock';
if (!file_exists($lockFile)) {
    file_put_contents($lockFile, 'INSTALLED - ' . date('Y-m-d H:i:s'));
}

/* =============================
   AMBIL DATA APLIKASI
============================= */
require '../config/database.php';
$q = mysqli_query($conn, "SELECT nama_aplikasi, logo FROM sekolah LIMIT 1");
$app = mysqli_fetch_assoc($q);

$namaApp = $app['nama_aplikasi'] ?? 'Aplikasi CBT';
$logo    = $app['logo'] ? '../assets/logo/'.$app['logo'] : '';

/* =============================
   URL APLIKASI
============================= */
$baseUrl = (isset($_SERVER['HTTPS']) ? 'https' : 'http') . '://' .
           $_SERVER['HTTP_HOST'] .
           dirname(dirname($_SERVER['PHP_SELF']));

/* =============================
   FILE SHORTCUT (DOWNLOAD)
============================= */
$shortcutContent = "[InternetShortcut]
URL=$baseUrl
IconFile=$baseUrl/assets/logo/{$app['logo']}
IconIndex=0
";

$fileShortcut = "Shortcut_".preg_replace('/[^a-zA-Z0-9]/', '_', $namaApp).".url";
file_put_contents($fileShortcut, $shortcutContent);

/* =============================
   HAPUS SESSION INSTALL
============================= */
session_destroy();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Instalasi Selesai</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
  background:#f4f6f9;
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
}
.card{border-radius:18px}
.logo-center{
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  margin-bottom:20px;
}
.logo-center img{
  max-width:130px;
  margin-bottom:10px;
}
.check{
  font-size:64px;
  color:#20c997;
}
.footer{
  font-size:12px;
  color:#6c757d;
}
</style>
</head>

<body>
<div class="card shadow p-5 text-center" style="max-width:480px;width:100%">

  <div class="logo-center">
    <?php if($logo): ?>
      <center><img src="<?= $logo ?>" alt="Logo Sekolah"></center>
    <?php endif; ?>
    <h5 class="fw-bold mb-0"><?= htmlspecialchars($namaApp) ?></h5>
  </div>

  <div class="check mb-2">✓</div>

  <p class="text-muted mb-4">
    Instalasi aplikasi berhasil dan siap digunakan.
  </p>

  <div class="alert alert-success small">
    Klik tombol di bawah untuk membuat <b>icon aplikasi di Desktop</b>.
  </div>

  <a href="<?= $fileShortcut ?>" download class="btn btn-success px-5 mb-3">
    ⬇ Buat Icon Desktop
  </a>

  <br>

  <a href="../auth/login.php" class="btn btn-outline-secondary px-5">
    Masuk ke Aplikasi
  </a>

  <div class="footer mt-4">
    © <?= date('Y') ?> Dikembangkan oleh <b>Bang Zae</b>
  </div>

</div>
</body>
</html>
