<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal: ".mysqli_connect_error());

/* ================= PROTEKSI ADMIN ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH ================= */
$logo = 'default.png';
$qSekolah = mysqli_query($conn,"SELECT logo FROM sekolah LIMIT 1");
if ($qSekolah && mysqli_num_rows($qSekolah)) {
    $s = mysqli_fetch_assoc($qSekolah);
    if (!empty($s['logo'])) $logo = $s['logo'];
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* ================= DATA UJIAN AKTIF ================= */

$sql = "
SELECT 
    u.id,
    u.nama_ujian,
    u.durasi,
    CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS nama_kelas
FROM smart_cbt.ujian u
JOIN pkbm_taruna_qurani.kelas k 
     ON k.id = u.id_kelas
WHERE u.status='Aktif'
ORDER BY u.nama_ujian ASC
";

$qUjian = mysqli_query($conn,$sql);
if(!$qUjian) die("Query Error: ".mysqli_error($conn));
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>🔴 Status Ujian Live</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#0f172a;color:#fff}
.card{border-radius:16px}
.logo-live{max-height:80px}
.table{background:#fff;color:#000}
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#fff;
}
</style>
</head>

<body>
<div class="container py-4">

<!-- ===== HEADER ===== -->
<div class="text-center mb-4">
  <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" class="logo-live mb-2">
  <h4 class="fw-bold mb-0">🔴 STATUS UJIAN (LIVE)</h4>
  <small class="opacity-75">Pilih ujian yang sedang berlangsung</small>
</div>

<!-- ===== CARD ===== -->
<div class="card shadow">
<div class="card-body p-0">

<table class="table table-bordered align-middle mb-0">
<thead class="table-dark">
<tr>
  <th width="60">No</th>
  <th>Nama Ujian</th>
  <th width="140">Kelas</th>
  <th width="120">Durasi</th>
  <th width="140">Aksi</th>
</tr>
</thead>
<tbody>

<?php if(mysqli_num_rows($qUjian)>0): ?>
<?php $no=1; while($u=mysqli_fetch_assoc($qUjian)): ?>
<tr>
  <td class="text-center"><?= $no++ ?></td>
  <td><?= htmlspecialchars($u['nama_ujian']) ?></td>
  <td class="text-center"><?= htmlspecialchars($u['nama_kelas'] ?? '-') ?></td>
  <td class="text-center"><?= (int)$u['durasi'] ?> menit</td>
  <td class="text-center">
    <a href="status_ujian.php?ujian_id=<?= (int)$u['id'] ?>" class="btn btn-sm btn-primary">
      📷 Monitor
    </a>
  </td>
</tr>
<?php endwhile; ?>
<?php else: ?>
<tr>
  <td colspan="5" class="text-center text-muted py-4">
    ❌ Tidak ada ujian aktif
  </td>
</tr>
<?php endif; ?>

</tbody>
</table>

</div>
</div>

<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dikembangkan oleh <b>Bang Zae</b>
</div>

</div>
</body>
</html>
