<?php
require __DIR__ . '/../config/database.php';

if (session_status() === PHP_SESSION_NONE) session_start();

/* ================= PROTEKSI ADMIN ================= */
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $c = mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if ($c && mysqli_num_rows($c)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah'] ?? $nama_sekolah;
            $logo          = $s['logo'] ?? $logo;
        }
        break;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= AUTO DETEKSI TABEL SISWA ================= */
$tblSiswa = '';
$tbl = mysqli_query($conn,"SHOW TABLES");
while($t = mysqli_fetch_row($tbl)){
    if (preg_match('/siswa|murid|peserta|student/i',$t[0])) {
        $tblSiswa = $t[0];
        break;
    }
}
if (!$tblSiswa) die("❌ Tabel siswa tidak ditemukan di database");

/* ================= AUTO DETEKSI KOLOM ================= */
$colNama  = '';
$colKelas = '';

$col = mysqli_query($conn,"SHOW COLUMNS FROM `$tblSiswa`");
while($c=mysqli_fetch_assoc($col)){
    if (preg_match('/nama/i',$c['Field'])) $colNama = $c['Field'];
    if (preg_match('/kelas/i',$c['Field'])) $colKelas = $c['Field'];
}

if(!$colNama) die("❌ Kolom nama siswa tidak ditemukan di tabel $tblSiswa");

/* ================= QUERY RANKING ================= */
$sql = "
SELECT 
    s.$colNama AS nama,
    ".($colKelas ? "s.$colKelas AS kelas," : "'' AS kelas,")."
    h.nilai
FROM hasil h
JOIN `$tblSiswa` s ON s.id = h.id_siswa
ORDER BY h.nilai DESC, nama ASC
";

$q = mysqli_query($conn,$sql);
if(!$q) die("Query Error: ".mysqli_error($conn));
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ranking Nilai</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
</head>

<body class="bg-light">

<div class="container-fluid">
  <h4 class="fw-bold mb-3">🏆 RANKING NILAI UJIAN</h4>

  <table class="table table-bordered table-striped text-center">
    <thead class="table-dark">
      <tr>
        <th width="80">Rank</th>
        <th>Nama</th>
        <th width="120">Kelas</th>
        <th width="100">Nilai</th>
      </tr>
    </thead>
    <tbody>

    <?php if(mysqli_num_rows($q)==0): ?>
      <tr>
        <td colspan="4" class="text-muted">Belum ada data nilai</td>
      </tr>
    <?php else: $rank=1; while($r=mysqli_fetch_assoc($q)): ?>

      <tr>
        <td><?= $rank++ ?></td>
        <td class="text-start"><?= htmlspecialchars($r['nama']) ?></td>
        <td><?= htmlspecialchars($r['kelas'] ?: '-') ?></td>
        <td class="fw-bold text-success"><?= (int)$r['nilai'] ?></td>
      </tr>

    <?php endwhile; endif; ?>

    </tbody>
  </table>
</div>

</body>
</html>
<?php
require __DIR__ . '/../config/database.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach ($tables as $t) {
    $c = mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if ($c && mysqli_num_rows($c)) {
        $q = mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if ($q && mysqli_num_rows($q)) {
            $s = mysqli_fetch_assoc($q);
            $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
            $nama_sekolah  = $s['nama_sekolah'] ?? $nama_sekolah;
            $logo          = $s['logo'] ?? $logo;
        }
        break;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= PROTEKSI ADMIN ================= */
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    $_SESSION['user']['role'] !== 'admin'
) {
    die('❌ AKSES DITOLAK');
}

/* ================= QUERY RANKING ================= */
$q = mysqli_query($conn,"
    SELECT 
        s.nama,
        s.kelas,
        h.nilai
    FROM hasil h
    JOIN pkbm_taruna_qurani.siswa s 
        ON s.id = h.id_siswa
    ORDER BY h.nilai DESC, s.nama ASC
");

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ranking Nilai</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9}
.sidebar{
  width:260px;
  min-height:100vh;
  background:#1f2937;
  color:#fff;
  position:fixed
}
.brand{
  padding:16px;
  background:#111827;
  display:flex;
  gap:12px;
  align-items:center
}
.brand img{width:36px}
.sidebar a{
  color:#cbd5e1;
  padding:10px 16px;
  display:block;
  text-decoration:none
}
.sidebar a:hover,
.sidebar a.active{
  background:#2563eb;
  color:#fff
}
.submenu a{
  padding-left:42px;
  font-size:14px
}
.content{
  margin-left:260px;
  padding:24px
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar position-fixed">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <div><?= htmlspecialchars($nama_aplikasi) ?></div>
      <small style="opacity:.7"><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php">
    <i class="bi bi-speedometer2 me-2"></i> Dashboard
  </a>
  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
    <a href="mapel.php">📘 Mata Pelajaran</a>
    <a href="kelas.php">🏫 Kelas</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>

  <a href="import_soal.php">
    <i class="bi bi-journal-text me-2"></i> Bank Soal
  </a>

  <a data-bs-toggle="collapse" href="#ujian">
    <i class="bi bi-pencil-square me-2"></i> Ujian
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse submenu" id="ujian">
    <a href="ujian.php">📝 Daftar Ujian</a>
    <a href="paket.php">📦 Paket</a>
    <a href="token.php">🔑 Token</a>
  </div>

  <a data-bs-toggle="collapse" href="#hasil" class="active">
    <i class="bi bi-bar-chart-line me-2"></i> Hasil
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="hasil">
    <a href="hasil.php" class="active">📊 Nilai</a>
    <a href="ranking.php">🏆 Ranking</a>
  </div>

  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

    <!-- CONTENT -->
    <main class="content flex-fill p-4 bg-light">
        <h4 class="fw-bold mb-3">🏆 RANKING NILAI UJIAN</h4>

        <div class="table-responsive">
            <table class="table table-bordered table-striped align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th width="80">Rank</th>
                        <th>Nama</th>
                        <th width="120">Kelas</th>
                        <th width="100">Nilai</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!$q || mysqli_num_rows($q) == 0): ?>
                    <tr>
                        <td colspan="4" class="text-muted">Belum ada data nilai</td>
                    </tr>
                <?php else: ?>
                <?php $rank=1; while($r=mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td class="fw-bold"><?= $rank++ ?></td>
                        <td class="text-start"><?= htmlspecialchars($r['nama']) ?></td>
                        <td><?= htmlspecialchars($r['kelas'] ?? '-') ?></td>
                        <td class="fw-bold text-success"><?= (int)$r['nilai'] ?></td>
                    </tr>
                <?php endwhile ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

