<?php
require __DIR__ . '/../config/database.php';
session_start();

if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

$msg = null;

if (isset($_POST['import'])) {

    if (!isset($_FILES['file']) || $_FILES['file']['error'] !== 0) {
        $msg = "File tidak valid";
    } else {

        $ext = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
        if ($ext !== 'csv') {
            $msg = "Gunakan file CSV (Excel → Save As → CSV)";
        } else {

            $file = fopen($_FILES['file']['tmp_name'], 'r');
            fgetcsv($file); // skip header

            $berhasil = 0;
            $gagal    = 0;

            while (($row = fgetcsv($file, 1000, ',')) !== false) {

                [
                    $nisn,
                    $nama,
                    $tempat_lahir,
                    $tanggal_lahir,
                    $jk,
                    $kelas,
                    $status
                ] = $row;

                $nisn   = trim($nisn);
                $nama   = trim($nama);
                $jk     = strtoupper(trim($jk));
                $kelas  = trim($kelas);
                $status = ucfirst(strtolower(trim($status)));

                if (
                    !$nisn ||
                    !$nama ||
                    !in_array($jk, ['L','P']) ||
                    !strtotime($tanggal_lahir)
                ) {
                    $gagal++;
                    continue;
                }

                /* CEK DUPLIKAT NISN */
                $cek = mysqli_query(
                    $conn,
                    "SELECT id FROM siswa WHERE nisn='$nisn' LIMIT 1"
                );
                if (mysqli_num_rows($cek)) {
                    $gagal++;
                    continue;
                }

                /* PASSWORD = TANGGAL LAHIR (YYYYMMDD) */
                $password_plain = date('Ymd', strtotime($tanggal_lahir));
                $password_hash  = password_hash($password_plain, PASSWORD_DEFAULT);

                $stmt = mysqli_prepare($conn,"
                    INSERT INTO siswa
                    (nisn,nama,tempat_lahir,tanggal_lahir,jk,kelas,password,status)
                    VALUES (?,?,?,?,?,?,?,?)
                ");

                mysqli_stmt_bind_param(
                    $stmt,
                    "ssssssss",
                    $nisn,
                    $nama,
                    $tempat_lahir,
                    $tanggal_lahir,
                    $jk,
                    $kelas,
                    $password_hash,
                    $status
                );

                if (mysqli_stmt_execute($stmt)) {
                    $berhasil++;
                } else {
                    $gagal++;
                }

                mysqli_stmt_close($stmt);
            }

            fclose($file);

            $msg = "Import selesai. Berhasil: $berhasil | Gagal: $gagal";
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Import Siswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">

<h4 class="fw-bold mb-3">📥 Import Data Siswa</h4>

<?php if ($msg): ?>
<div class="alert alert-info"><?= htmlspecialchars($msg) ?></div>
<?php endif ?>

<div class="card shadow-sm">
<div class="card-body">

<form method="post" enctype="multipart/form-data">
  <div class="mb-3">
    <label class="form-label">File CSV</label>
    <input type="file" name="file" class="form-control" accept=".csv" required>
    <small class="text-muted">
      Password otomatis = Tanggal Lahir (YYYYMMDD)
    </small>
  </div>
  <button name="import" class="btn btn-primary">
    Import Siswa
  </button>
</form>

</div>
</div>

</body>
</html>
