<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ===== KONEKSI PKBM ===== */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2){
    die("Koneksi PKBM gagal: ".mysqli_connect_error());
}

$kelas = $_GET['kelas'] ?? '';
if($kelas=='') die('Kelas kosong');

/* ================= PROFIL SEKOLAH ================= */
$nama_sekolah = 'SEKOLAH';
$alamat       = '';
$logo         = 'default.png';

$q = mysqli_query($conn,"SHOW TABLES LIKE 'sekolah'");
if ($q && mysqli_num_rows($q) > 0) {
    $qs = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
    if($qs && mysqli_num_rows($qs)>0){
        $d = mysqli_fetch_assoc($qs);
        $nama_sekolah = $d['nama_sekolah'] ?? $nama_sekolah;
        $alamat       = $d['alamat'] ?? '';
        $logo         = $d['logo'] ?? $logo;
    }
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* ================= QUERY DATA ================= */
$data = mysqli_query($conn,"
    SELECT 
        s.nama,
        s.nisn,
        m.nama_mapel,
        u.nama_ujian,
        h.nilai
    FROM hasil h
    JOIN ujian u ON h.id_ujian = u.id
    JOIN pkbm_taruna_qurani.siswa s 
         ON s.id = h.id_siswa
    LEFT JOIN pkbm_taruna_qurani.mapel m 
         ON m.id = u.id_mapel
    JOIN pkbm_taruna_qurani.kelas k 
         ON k.id = s.kelas_id
    WHERE k.id = '".mysqli_real_escape_string($conn2,$kelas)."'
    ORDER BY s.nama, m.nama_mapel
");

if(!$data) die("Query error: ".mysqli_error($conn));
?>
<!doctype html>
<html>
<head>
<meta charset="UTF-8">
<title>Cetak Nilai Kelas</title>
<style>
@page{size:A4;margin:12mm}
body{font-family:Arial;font-size:11px;color:#000}

table{width:100%;border-collapse:collapse}
th,td{border:1px solid #000;padding:4px}
th{background:#eee}

h3{text-align:center;margin:10px 0}

.garis-dinas{
  border-top:3px solid #000;
  border-bottom:1px solid #000;
  height:6px;
  margin:8px 0 16px
}
.kop, .kop *{
    border:0 !important;
}
.kop{
    border-collapse:separate !important;
}

</style>
</head>
<body onload="window.print()">

<!-- KOP SEKOLAH -->
<table width="100%" class="kop">

<tr>
  <td width="90" class="text-center align-middle">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" width="80">
  </td>
  <td class="align-middle">
    <div class="fw-bold text-uppercase" style="font-size:18px">
      <?= htmlspecialchars($nama_sekolah) ?>
    </div>
    <div style="font-size:13px">
      <?= htmlspecialchars($alamat) ?>
    </div>
  </td>
</tr>
</table>

<div class="garis-dinas"></div>

<h3>REKAP NILAI KELAS <?= strtoupper(htmlspecialchars($kelas)) ?></h3>

<table>
<tr>
<th width="40">No</th>
<th>Nama</th>
<th width="120">NISN</th>
<th>Mata Pelajaran</th>
<th>Ujian</th>
<th width="60">Nilai</th>
</tr>

<?php if(mysqli_num_rows($data)==0): ?>
<tr>
<td colspan="6" align="center">Data tidak ditemukan</td>
</tr>
<?php endif; ?>

<?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td align="center"><?= $no++ ?></td>
<td><?= htmlspecialchars($r['nama']) ?></td>
<td><?= htmlspecialchars($r['nisn']) ?></td>
<td><?= htmlspecialchars($r['nama_mapel'] ?? '-') ?></td>
<td><?= htmlspecialchars($r['nama_ujian']) ?></td>
<td align="center"><b><?= (int)$r['nilai'] ?></b></td>
</tr>
<?php endwhile ?>
</table>

</body>
</html>
