<?php
error_reporting(E_ALL);
ini_set('display_errors',1);

require __DIR__ . '/../config/database.php';

/* ================== KONEKSI PKBM ================== */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal: ".mysqli_connect_error());

/* ================== SESSION ================== */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])){
    header("Location: ../auth/login.php");
    exit;
}

/* ================== PROFIL SEKOLAH ================== */
$nama_sekolah='SEKOLAH';
$logo='default.png';

$q=mysqli_query($conn,"SELECT nama_sekolah,logo FROM sekolah LIMIT 1");
if($q && mysqli_num_rows($q)){
    $s=mysqli_fetch_assoc($q);
    $nama_sekolah=$s['nama_sekolah'] ?: $nama_sekolah;
    $logo=$s['logo'] ?: $logo;
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================== PARAMETER MODE ================== */
$kelas_id = (int)($_POST['kelas'] ?? $_GET['kelas'] ?? 0);
$mode     = $_POST['mode'] ?? 'single';
$id_siswa = $_GET['siswa'] ?? null;
$siswaArr = $_POST['siswa'] ?? [];

if($kelas_id<=0) die("Kelas tidak valid");

/* ================== AUTO DETEKSI FIELD ================== */
function detectField($conn,$table,$candidates){
    foreach($candidates as $f){
        $q=mysqli_query($conn,"SHOW COLUMNS FROM `$table` LIKE '$f'");
        if($q && mysqli_num_rows($q)) return $f;
    }
    return '';
}

$fk_siswa_kelas = detectField($conn2,'siswa',['kelas_id','id_kelas','kelas']);
$fk_kelas_id    = detectField($conn2,'kelas',['id','kelas_id']);
$fk_ujian_kelas = detectField($conn,'ujian',['id_kelas','kelas_id','kelas']);

if(!$fk_siswa_kelas || !$fk_kelas_id) die("Struktur tabel siswa/kelas tidak cocok");

/* ================== FILTER SISWA ================== */
$where = "";

if($mode=='kelas'){
    $where = "s.$fk_siswa_kelas=$kelas_id";
}
elseif($mode=='pilihan' && !empty($siswaArr)){
    $ids = array_map('intval',$siswaArr);
    $where = "s.id IN(".implode(',',$ids).")";
}
elseif($id_siswa){
    $where = "s.id=".(int)$id_siswa;
}
else{
    die("Mode cetak tidak valid");
}

/* ================== DATA SISWA ================== */
$siswa=mysqli_query($conn2,"
    SELECT s.id,s.nama,s.nisn,s.username,
           CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS nama_kelas
    FROM siswa s
    JOIN kelas k ON s.$fk_siswa_kelas = k.$fk_kelas_id
    WHERE $where
    ORDER BY s.nama
");

if(!$siswa || mysqli_num_rows($siswa)==0) die("Tidak ada data siswa");

/* ================== DAFTAR UJIAN ================== */
$daftarUjian=[];

if($fk_ujian_kelas){
    $uj=mysqli_query($conn,"
        SELECT DISTINCT p.nama_paket
        FROM ujian u
        JOIN paket_ujian p ON u.id_paket=p.id
        WHERE u.$fk_ujian_kelas=$kelas_id
          AND u.status='Aktif'
    ");
    while($u=mysqli_fetch_assoc($uj)){
        $daftarUjian[]=$u['nama_paket'];
    }
}
if(!$daftarUjian) $daftarUjian[]='Belum ada ujian aktif';

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Kartu Ujian</title>

<style>
@page{size:A4;margin:10mm}
body{font-family:Arial;font-size:12px}
.kartu{
    width:48%;
    border:1px solid #000;
    padding:12px;
    margin:5px 1%;
    float:left;
    box-sizing:border-box;
    page-break-inside:avoid;
}
.kartu:nth-child(2n+1){clear:left}
.header{
    display:flex;
    gap:10px;
    border-bottom:2px solid #000;
    padding-bottom:8px;
    margin-bottom:6px
}
.header img{width:55px}
.nama-sekolah{font-weight:bold;font-size:16px}
.judul{
    font-weight:bold;
    font-size:16px;
    text-align:center;
    margin:6px 0 10px 0
}
.clear{clear:both}
</style>
</head>

<body onload="window.print()">

<?php while($s=mysqli_fetch_assoc($siswa)): ?>
<div class="kartu">

<div class="header">
  <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
  <div>
    <div class="nama-sekolah"><?= htmlspecialchars($nama_sekolah) ?></div>
    <small>Alamat Sekolah</small>
  </div>
</div>

<div class="judul">KARTU PESERTA UJIAN</div>

<table width="100%">
<tr><td width="30%">Nama</td><td>: <?= htmlspecialchars($s['nama']) ?></td></tr>
<tr><td>NISN</td><td>: <?= htmlspecialchars($s['nisn']) ?></td></tr>
<tr><td>Username</td><td>: <b><?= htmlspecialchars($s['username']) ?></b></td></tr>
<tr><td>Kelas</td><td>: <?= htmlspecialchars($s['nama_kelas']) ?></td></tr>
</table>

<hr>

<b>Daftar Ujian:</b>
<ol>
<?php foreach($daftarUjian as $u): ?>
<li><?= htmlspecialchars($u) ?></li>
<?php endforeach ?>
</ol>

<small>
<b>Login:</b><br>
Username : <b><?= htmlspecialchars($s['username']) ?></b><br>
Password : <b>Tanggal Lahir (ddmmyyyy)</b>
<hr>
Simpan kartu ini dengan baik.
</small>

</div>
<?php endwhile ?>

<div class="clear"></div>
</body>
</html>
