<?php
session_start();
require "koneksi.php";

if (empty($_SESSION['login_tutor'])) {
  header("Location: login.php");
  exit;
}

$nama = $_SESSION['nama'];
$tutor_id = (int)$_SESSION['tutor_id'];
$tanggal = date('Y-m-d');

/* ===== CEK STATUS HARI INI ===== */
$mode_default = "masuk";
$jam_terakhir = "";

$q = mysqli_query($conn, "
  SELECT waktu, waktu_pulang 
  FROM presensi_guru 
  WHERE tutor_id='$tutor_id' 
    AND tanggal='$tanggal'
    AND status='hadir'
  LIMIT 1
");

if ($q && mysqli_num_rows($q) === 1) {
  $p = mysqli_fetch_assoc($q);

  if (!empty($p['waktu']) && empty($p['waktu_pulang'])) {
    $mode_default = "pulang";
    $jam_terakhir = substr($p['waktu'], 0, 8);
  }

  if (!empty($p['waktu']) && !empty($p['waktu_pulang'])) {
    $mode_default = "sudah";
    $jam_terakhir = substr($p['waktu_pulang'], 0, 8);
  }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Presensi Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
  font-family:'Segoe UI',sans-serif;
  background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
  display:flex;
  justify-content:center;
  align-items:center;
  height:100vh;
  margin:0;
  padding-bottom:70px;
}

/* PHONE */
.phone{
  width:360px;
  height:720px;
  background:#fff;
  border-radius:30px;
  box-shadow:0 12px 35px rgba(0,0,0,.25);
  overflow:hidden;
  padding:16px;
  text-align:center;
}

/* CAMERA */
.camera-box{
  position:relative;
  border-radius:24px;
  overflow:hidden;
  box-shadow:0 0 0 4px #f57c00, 0 10px 30px rgba(0,0,0,.35);
}
video{
  width:100%;
}

/* FACE FRAME */
.face-frame{
  position:absolute;
  width:70%;
  height:80%;
  border:3px solid rgba(255,255,255,.8);
  border-radius:50%;
  top:10%;
  left:15%;
  pointer-events:none;
}
.face-frame{
  border-radius:16px;
  border:2px solid rgba(255,255,255,.7);
}

/* BUTTON */
button{
  width:100%;
  padding:14px;
  border:none;
  border-radius:14px;
  background:linear-gradient(135deg,#f57c00,#fbc02d);
  color:#fff;
  font-size:16px;
  font-weight:700;
  margin-top:14px;
  cursor:pointer;
}
button:active{transform:scale(.97)}

#status{font-size:13px;color:#444;margin-top:8px}

/* MODAL */
.modal{
  position:fixed;
  inset:0;
  background:rgba(0,0,0,.6);
  display:none;
  align-items:center;
  justify-content:center;
  z-index:9999;
}
.modal-box{
  background:#fff;
  width:300px;
  border-radius:18px;
  padding:16px;
  font-size:13px;
}
.modal h4{text-align:center;margin:0 0 10px}
.modal b{display:inline-block;width:85px}
.modal button{margin-top:12px}

/* FOOTER */
.footer{
  position:fixed;
  bottom:0;left:0;right:0;
  background:#fff;
  border-top:1px solid #ddd;
  display:flex;
  justify-content:space-around;
  padding:6px 0;
}
.footer a{font-size:11px;color:#777;text-decoration:none;text-align:center}
.footer span{display:block;font-size:18px}
.footer a.active{color:#f57c00;font-weight:600}
</style>
</head>

<body>

<div class="phone">
  <h3>📍 Presensi Tutor</h3>
  <p>Halo, <b><?= htmlspecialchars($nama) ?></b></p>

  <div class="camera-box">
    <video id="video" autoplay playsinline></video>
    <div class="face-frame"></div>
  </div>

  <canvas id="canvas" style="display:none"></canvas>

  <button id="btnPresensi" onclick="mulaiPresensi()">
    📸 <?= $mode_default === 'pulang' ? 'Absen Pulang' : 'Mulai Presensi' ?>
  </button>

  <p id="status">Menyiapkan kamera & lokasi...</p>
</div>

<!-- POPUP -->
<div class="modal" id="popup">
  <div class="modal-box">
    <h4>📋 Data Presensi</h4>
    <div><b>Nama</b>: <?= htmlspecialchars($nama) ?></div>
    <div><b>Tanggal</b>: <span id="pTanggal"></span></div>
    <div><b>Jam</b>: <span id="pJam"></span></div>
    <div><b>Lat/Lng</b>: <span id="pKoord"></span></div>
    <div><b>Alamat</b>: <span id="pAlamat"></span></div>
    <button onclick="tutupPopup()">Tutup</button>
  </div>
</div>

<!-- POPUP SUDAH ABSEN -->
<div class="modal" id="popupSudah">
  <div class="modal-box">
    <h4>ℹ️ Informasi</h4>
    <p style="text-align:center">
      Anda <b>sudah absen</b><br>
      hari ini pukul<br>
      <b id="jamAbsen"></b>
    </p>
    <button onclick="window.location.href='dashboard.php'">
      Kembali ke Dashboard
    </button>
  </div>
</div>

<!-- FOOTER -->
<div class="footer">
  <a href="dashboard.php"><span>🏠</span>Home</a>
  <a class="active"><span>📸</span>Presensi</a>
  <a href="izin.php"><span>📝</span>Izin</a>
  <a href="history.php"><span>📜</span>History</a>
  <a href="profil.php"><span>👤</span>Profil</a>
</div>

<script>
let lat=null,lng=null,alamat='';
let mode = "<?= $mode_default ?>";
let jamTerakhir = "<?= $jam_terakhir ?>";

const video=document.getElementById("video");
const canvas=document.getElementById("canvas");
const statusEl=document.getElementById("status");
const btn=document.getElementById("btnPresensi");

/* CAMERA */
navigator.mediaDevices.getUserMedia({video:{facingMode:"user"}})
.then(s=>video.srcObject=s);

/* GPS */
navigator.geolocation.getCurrentPosition(async p=>{
  lat=p.coords.latitude;
  lng=p.coords.longitude;
  const r=await fetch(`https://nominatim.openstreetmap.org/reverse?format=json&lat=${lat}&lon=${lng}`);
  const d=await r.json();
  alamat=d.display_name||'-';
  statusEl.innerText="✅ Siap presensi";
});

/* JIKA SUDAH FULL */
if(mode === "sudah"){
  document.getElementById("jamAbsen").innerText = jamTerakhir;
  document.getElementById("popupSudah").style.display="flex";
  btn.disabled = true;
  btn.innerText = "✔ Sudah Presensi";
  statusEl.innerText = "Anda sudah absen masuk & pulang";
}

/* AUTO CAPTURE + KIRIM */
function mulaiPresensi(){
  if(!lat || !lng){
    alert("Lokasi belum siap");
    return;
  }

  const now=new Date();
  document.getElementById("pTanggal").innerText=now.toLocaleDateString();
  document.getElementById("pJam").innerText=now.toLocaleTimeString();
  document.getElementById("pKoord").innerText=lat.toFixed(5)+" , "+lng.toFixed(5);
  document.getElementById("pAlamat").innerText=alamat;

  document.getElementById("popup").style.display="flex";

  setTimeout(()=>{

    canvas.width=video.videoWidth;
    canvas.height=video.videoHeight;
    canvas.getContext("2d").drawImage(video,0,0);

    canvas.toBlob(blob=>{
      const formData = new FormData();
      formData.append("mode", mode);
      formData.append("foto", blob, "foto.jpg");
      formData.append("lat", lat);
      formData.append("lng", lng);
      formData.append("alamat", alamat);

      fetch("presensi_proses.php",{
        method:"POST",
        body: formData
      })
      .then(r=>r.json())
      .then(res=>{
        if(res.status==="ok"){
          alert("Absen " + res.mode + " berhasil jam " + res.jam);
          window.location.href="dashboard.php";
        }else{
          alert(res.message);
          document.getElementById("popup").style.display="none";
        }
      })
      .catch(()=>{
        alert("Gagal koneksi server");
        document.getElementById("popup").style.display="none";
      });

    }, "image/jpeg", 0.8);

  }, 1500);
}

function tutupPopup(){
  document.getElementById("popup").style.display="none";
}
</script>

</body>
</html>
