<?php
session_start();
require "koneksi.php"; // tetap untuk login user/tutor

$error = '';

if (isset($_POST['login'])) {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if ($username === '' || $password === '') {
        $error = "Username dan password wajib diisi";
    } else {
        $sql = "
            SELECT 
                u.id AS user_id,
                u.nama,
                u.password,
                t.id AS tutor_id
            FROM users u
            JOIN tutor t ON t.user_id = u.id
            WHERE u.username = ? AND u.role = 'tutor'
            LIMIT 1
        ";
        $stmt = mysqli_prepare($conn, $sql);
        mysqli_stmt_bind_param($stmt, "s", $username);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);

        if ($result && mysqli_num_rows($result) === 1) {
            $u = mysqli_fetch_assoc($result);
            if (password_verify($password, $u['password'])) {
                $_SESSION['login_tutor'] = true;
                $_SESSION['tutor_id']    = (int)$u['tutor_id'];
                $_SESSION['nama']        = $u['nama'];
                header("Location: dashboard.php");
                exit;
            }
        }
        $error = "Username atau password salah";
    }
}

// Path logo langsung dari folder
$logoPath = 'assets/logo/logo.PNG'; 
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Login Presensi</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{
  font-family:'Segoe UI',sans-serif;
  background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
  display:flex;
  justify-content:center;
  align-items:center;
  height:100vh;
  margin:0;
}
.box{
  background:#fff;
  padding:25px;
  border-radius:14px;
  box-shadow:0 10px 25px rgba(0,0,0,.15);
  width:320px;
  text-align:center;
}
.logo-login{
  max-width:100px;
  margin-bottom:15px;
  display:block;
  margin-left:auto;
  margin-right:auto;
}
h3{
  margin-bottom:15px;
}
input,button{
  width:100%;
  padding:12px;
  margin-top:10px;
  border-radius:8px;
  border:1px solid #ccc;
  font-size:14px;
}
button{
  background:#0d6efd;
  color:#fff;
  border:none;
  font-weight:600;
  cursor:pointer;
}
button:active{transform:scale(.98)}
.error{
  background:#ffecec;
  color:#c62828;
  padding:8px;
  border-radius:6px;
  font-size:13px;
  margin-bottom:10px;
  text-align:center
}
.btn-batal{
  display:block;
  text-align:center;
  margin-top:10px;
  padding:12px;
  border-radius:8px;
  background:#6c757d;
  color:#fff;
  text-decoration:none;
  font-weight:600
}
.footer{
  font-size:12px;
  color:#adb5bd;
}
.btn-batal:active{transform:scale(.98)}
</style>
</head>
<body>

<div class="box">
  
  <!-- Logo dari folder -->
  <img src="<?= htmlspecialchars($logoPath) ?>" class="logo-login" alt="Logo PKBM">

  <h3>Login Presensi</h3>

  <?php if ($error): ?>
    <div class="error"><?= htmlspecialchars($error) ?></div>
  <?php endif; ?>

  <form method="post" autocomplete="off">
    <input name="username" placeholder="Username" required>
    <input type="password" name="password" placeholder="Password" required>
    <button name="login">Login</button>
    <!-- TOMBOL BATAL -->
    <a href="/pkbm-test/index.html" class="btn-batal">Batal</a>
    <div class="text-center footer mt-3">
    Dikembangkan oleh <b>Team DHARMANANDA AGUNG ACADEMY</b>
  </div>
  </form>
</div>

</body>
</html>
