<?php
session_start();
require "koneksi.php";

if (empty($_SESSION['login_tutor'])) {
  header("Location: login.php");
  exit;
}

$tutor_id = (int)($_SESSION['tutor_id'] ?? 0);
$success = "";
$error   = "";

/* ================= HITUNG PENDING ================= */
$pending = mysqli_fetch_row(mysqli_query($conn, "
  SELECT COUNT(*) FROM izin_cuti
  WHERE tutor_id='$tutor_id'
    AND status_approval='pending'
"))[0] ?? 0;

/* ================= BATALKAN PENGAJUAN ================= */
if (isset($_GET['batal'])) {
  $id = (int)$_GET['batal'];

  $cek = mysqli_query($conn, "
    SELECT id FROM izin_cuti
    WHERE id='$id'
      AND tutor_id='$tutor_id'
      AND status_approval='pending'
    LIMIT 1
  ");

  if ($cek && mysqli_num_rows($cek) === 1) {
    mysqli_query($conn, "DELETE FROM izin_cuti WHERE id='$id'");
    $success = "Pengajuan berhasil dibatalkan";
  } else {
    $error = "Tidak dapat dibatalkan";
  }
}

/* ================= SIMPAN PENGAJUAN ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $jenis        = $_POST['jenis'] ?? '';
  $tgl_mulai    = $_POST['tanggal_mulai'] ?? '';
  $tgl_selesai  = $_POST['tanggal_selesai'] ?? '';
  $alasan       = trim($_POST['alasan'] ?? '');

  $kodeMap = [
    'cuti'  => 'C',
    'izin'  => 'I',
    'sakit' => 'S',
    'dinas' => 'DL'
  ];

  if (!isset($kodeMap[$jenis])) {
    $error = "Jenis izin tidak valid";
  } elseif (!$tgl_mulai || !$tgl_selesai || !$alasan) {
    $error = "Semua field wajib diisi";
  } elseif ($tgl_selesai < $tgl_mulai) {
    $error = "Tanggal selesai tidak boleh lebih kecil dari tanggal mulai";
  }

  if (!$error) {
    /* CEK BENTROK */
    $cek = mysqli_prepare($conn, "
      SELECT id FROM izin_cuti
      WHERE tutor_id=?
      AND tanggal_mulai <= ?
      AND tanggal_selesai >= ?
    ");
    mysqli_stmt_bind_param($cek, "iss", $tutor_id, $tgl_selesai, $tgl_mulai);
    mysqli_stmt_execute($cek);
    $res = mysqli_stmt_get_result($cek);

    if ($res && mysqli_num_rows($res) > 0) {
      $error = "Tanggal bentrok dengan izin/cuti lain";
    }
  }

  /* UPLOAD FILE */
  $lampiran = null;
  if (!$error && !empty($_FILES['lampiran']['name'])) {
    $folder = __DIR__ . "/uploads/izin/";
    if (!is_dir($folder)) mkdir($folder, 0777, true);

    $ext = strtolower(pathinfo($_FILES['lampiran']['name'], PATHINFO_EXTENSION));
    $allow = ['jpg','jpeg','png','pdf'];

    if (!in_array($ext, $allow)) {
      $error = "Lampiran harus JPG, PNG atau PDF";
    } else {
      $lampiran = "izin_" . $tutor_id . "_" . date('Ymd_His') . "." . $ext;
      if (!move_uploaded_file($_FILES['lampiran']['tmp_name'], $folder.$lampiran)) {
        $error = "Gagal upload lampiran";
      }
    }
  }

  /* ================= LIMIT 3X & 3 HARI ================= */
$q = mysqli_query($conn,"
  SELECT 
    COUNT(*) AS total_pengajuan,
    SUM(DATEDIFF(tanggal_selesai, tanggal_mulai)+1) AS total_hari
  FROM izin_cuti
  WHERE tutor_id='$tutor_id'
  AND DATE_FORMAT(tanggal_mulai,'%Y-%m')='".date('Y-m')."'
");

$lim = mysqli_fetch_assoc($q);
$cnt = (int)$lim['total_pengajuan'];
$days = (int)$lim['total_hari'];

$apply_days = (new DateTime($tgl_mulai))->diff(new DateTime($tgl_selesai))->days + 1;

if($cnt >= 3){
  $error = "Limit pengajuan bulan ini sudah 3x";
}
elseif(($days + $apply_days) > 3){
  $error = "Total hari izin bulan ini melebihi 3 hari";
}


  /* ================= INSERT & WA ================= */
  if (!$error) {
    $kode = $kodeMap[$jenis];
    mysqli_query($conn, "
      INSERT INTO izin_cuti
      (tutor_id, jenis, kode, tanggal_mulai, tanggal_selesai, alasan, lampiran, status_approval, created_at)
      VALUES ('$tutor_id','$jenis','$kode','$tgl_mulai','$tgl_selesai','$alasan','$lampiran','pending',NOW())
    ");

    /* ================= NOTIF WA ================= */
    $no_admin = "628818124566";

    $pesan = rawurlencode("Pengajuan izin/cuti baru:
Jenis : $jenis
Tanggal : $tgl_mulai s/d $tgl_selesai
Tutor ID : $tutor_id
Perlu persetujuan admin.");

    @file_get_contents("https://api.callmebot.com/whatsapp.php?phone=$no_admin&text=$pesan");

    /* ================= SUCCESS ================= */
    $success = "Pengajuan berhasil dikirim, menunggu persetujuan admin";

    header("Location: izin.php?sent=1");
    exit;
  }
} // <--- ini penting untuk nutup POST
/* ================= RIWAYAT ================= */
$list = mysqli_query($conn, "
  SELECT * FROM izin_cuti
  WHERE tutor_id='$tutor_id'
  ORDER BY created_at DESC
");

/* ================= KALENDER APPROVED ================= */
$kal = [];
$qkal = mysqli_query($conn, "
  SELECT tanggal_mulai, tanggal_selesai, jenis, status_approval, alasan
  FROM izin_cuti
  WHERE tutor_id='$tutor_id'
");

while($r = mysqli_fetch_assoc($qkal)){
  $start = new DateTime($r['tanggal_mulai']);
  $end   = new DateTime($r['tanggal_selesai']);
  $end->modify('+1 day');

  foreach(new DatePeriod($start, new DateInterval('P1D'), $end) as $d){
    $kal[$d->format("Y-m-d")] = [
      'jenis'  => $r['jenis'],
      'status' => $r['status_approval'],
      'alasan' => $r['alasan']
    ];
  }
}

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Pengajuan Izin / Cuti</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{margin:0;font-family:'Segoe UI',sans-serif;background:#f3f4f8;padding-bottom:80px}
.topbar{background:linear-gradient(135deg,#d4af37,#f6e27a);padding:14px;color:#222;font-weight:600;display:flex;justify-content:space-between}
.card{background:#fff;margin:12px;border-radius:16px;padding:16px;box-shadow:0 8px 20px rgba(0,0,0,.08)}
button{width:100%;padding:14px;border:none;border-radius:14px;background:linear-gradient(135deg,#f57c00,#fbc02d);color:#fff;font-size:15px;font-weight:700}
textarea,input,select{width:100%;padding:10px;margin:6px 0 12px;border-radius:10px;border:1px solid #ddd}
.calendar{display:grid;grid-template-columns:repeat(7,1fr);gap:6px;margin-top:10px}
.day{background:#eee;padding:10px 0;border-radius:8px;text-align:center;font-size:12px}
.day.mark{background:#f57c00;color:#fff;font-weight:700}
.item{background:#fff;border-radius:14px;padding:12px;margin-bottom:10px;box-shadow:0 4px 10px rgba(0,0,0,.08);font-size:13px}
.status{padding:4px 8px;border-radius:8px;font-size:11px;font-weight:700}
.pending{background:#fff3cd;color:#856404}
.approved{background:#d4edda;color:#155724}
.rejected{background:#f8d7da;color:#721c24}
.btn-cancel{display:inline-block;background:#eee;padding:6px;border-radius:8px;font-size:12px;text-decoration:none;color:#333}
.footer{position:fixed;bottom:0;left:0;right:0;background:#fff;border-top:1px solid #ddd;display:flex;justify-content:space-around;padding:6px 0}
.footer a{text-decoration:none;font-size:11px;color:#555;text-align:center}
.footer span{display:block;font-size:18px}
.footer a.active{color:#f57c00;font-weight:600}
.popup{position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;justify-content:center;align-items:center}
.popup-box{background:#fff;width:90%;max-width:420px;border-radius:18px;padding:18px}
.day.mark.cuti   { background:#8e44ad; color:#fff; } /* ungu */
.day.mark.izin   { background:#f39c12; color:#fff; } /* oren */
.day.mark.sakit  { background:#e74c3c; color:#fff; } /* merah */
.day.mark.dinas  { background:#16a085; color:#fff; } /* hijau tua */

.day.mark.pending { filter: brightness(80%); }
.day.mark.approved { }
.day.mark.rejected { filter: grayscale(70%); opacity:.7; }



</style>
</head>
<div id="popupDay" class="popup">
  <div class="popup-box" id="popupDayContent"></div>
  <button onclick="closeDay()" style="margin-top:8px;">Tutup</button>
</div>

<body>

<div class="topbar">
  <span>📆 Pengajuan Izin / Cuti</span>
  <?php if($pending>0): ?><span><?= $pending ?> Pending</span><?php endif; ?>
</div>

<div class="card">
  <button onclick="openForm()">➕ Ajukan</button>
  <?php if($success): ?><div><?= $success ?></div><?php endif; ?>
  <?php if($error): ?><div><?= $error ?></div><?php endif; ?>
</div>

<div class="card">
  <b>Kalender Bulan Ini</b>
  <div class="calendar" id="calendar"></div>
</div>

<div class="card">
  <b>Riwayat</b>
<?php while($r=mysqli_fetch_assoc($list)): ?>
<?php $dif=(new DateTime($r['tanggal_mulai']))->diff(new DateTime($r['tanggal_selesai']))->days+1; ?>
  <div class="item">
    <div><b><?= strtoupper($r['jenis']) ?></b> (<?= $dif ?> hari)</div>
    <div>📅 <?= $r['tanggal_mulai'] ?> — <?= $r['tanggal_selesai'] ?></div>
    <span class="status <?= $r['status_approval'] ?>"><?= strtoupper($r['status_approval']) ?></span><br>
    <div>Alasan: <?= htmlspecialchars($r['alasan']) ?></div>
    <?php if($r['lampiran']): ?>
      <a href="uploads/izin/<?= $r['lampiran'] ?>" target="_blank">📎 Lampiran</a><br>
    <?php endif; ?>
    <?php if($r['status_approval']==='pending'): ?>
      <a href="?batal=<?= $r['id'] ?>" class="btn-cancel" onclick="return confirm('Batalkan pengajuan?')">❌ Batalkan</a>
    <?php endif; ?>
  </div>
<?php endwhile; ?>
</div>

<div id="popupForm" class="popup">
  <div class="popup-box">
    <h3>Form Pengajuan</h3>
    <form method="post" enctype="multipart/form-data">
      <label>Jenis</label>
      <select name="jenis" required>
        <option value="cuti">Cuti</option>
        <option value="izin">Izin</option>
        <option value="sakit">Sakit</option>
        <option value="dinas">Dinas luar</option>
      </select>
      <label>Tanggal Mulai</label>
      <input type="date" name="tanggal_mulai" required>
      <label>Tanggal Selesai</label>
      <input type="date" name="tanggal_selesai" required>
      <label>Alasan</label>
      <textarea name="alasan" rows="3" required></textarea>
      <label>Lampiran (opsional)</label>
      <input type="file" name="lampiran" accept=".jpg,.jpeg,.png,.pdf">
      <button type="submit">📤 Kirim</button>
      <button type="button" style="background:#eee;margin-top:8px" onclick="closeForm()">✖ Tutup</button>
    </form>
  </div>
</div>

<div class="footer">
  <a href="dashboard.php"><span>🏠</span>Home</a>
  <a href="presensi.php"><span>📸</span>Presensi</a>
  <a class="active"><span>📝</span>Izin</a>
  <a href="history.php"><span>📜</span>History</a>
  <a href="profil.php"><span>👤</span>Profil</a>
</div>

<script>
const cal=document.getElementById("calendar");
const dates = <?= json_encode($kal) ?>;
const now=new Date(),y=now.getFullYear(),m=now.getMonth();
const last=new Date(y,m+1,0).getDate();
for(let i=1;i<=last;i++){
  const d=new Date(y,m,i).toISOString().slice(0,10);
  const div=document.createElement("div");
  div.className="day";
  if(dates[d]){
 div.classList.add("mark", dates[d].jenis, dates[d].status);
  div.onclick = ()=>showDay(d);
}

  div.innerText=i;
  cal.appendChild(div);
}
function openForm(){document.getElementById("popupForm").style.display="flex";}
function closeForm(){document.getElementById("popupForm").style.display="none";}

function showDay(tgl){
  const data = dates[tgl];
  let html = `<b>${tgl}</b><br><br>`;
  html += `<b>${data.jenis.toUpperCase()}</b><br>`;
  html += `Alasan: ${data.alasan}<br>`;
  html += `Status: ${data.status.toUpperCase()}`;
  document.getElementById("popupDayContent").innerHTML = html;
  document.getElementById("popupDay").style.display="flex";
}
function closeDay(){ document.getElementById("popupDay").style.display="none"; }

</script>
</body>
</html>
