<?php
session_start();
require_once __DIR__ . '/edu_digital/config/database.php';

$fotoFolder = '/pkbm-test/edu_digital/uploads/guru-manajemen/';

/* ================= QUERY ================= */

/* KEPALA SEKOLAH */
$kepsek = mysqli_query($conn,"
SELECT * FROM guru_manajemen
WHERE (jabatan LIKE '%kepala%' OR jabatan LIKE '%kepsek%')
ORDER BY id DESC
LIMIT 1
");

/* GURU */
$guru = mysqli_query($conn,"
SELECT * FROM guru_manajemen
WHERE status = 'Guru'
ORDER BY nama
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Manajemen & Guru</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>
body{
  margin:0;
  font-family:'Segoe UI',sans-serif;
  background:linear-gradient(135deg,#020617,#0f172a);
  color:#fff;
}

.phone{
  max-width:430px;
  margin:auto;
  min-height:100vh;
  padding-bottom:90px;
}

/* HEADER */
.header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:12px;
  backdrop-filter:blur(12px);
  background:rgba(255,255,255,.05);
}

.logo{
  width:40px;
  height:40px;
  border-radius:50%;
  object-fit:cover;
}

.header-title{
  flex:1;
  text-align:center;
  font-weight:700;
}

/* KEPSEK */
.vip{
  margin:16px;
  border-radius:24px;
  overflow:hidden;
  background:linear-gradient(135deg,#1e293b,#020617);
  box-shadow:0 20px 50px rgba(0,0,0,.6);
}

.vip img{
  width:100%;
  aspect-ratio:3/4;
  object-fit:cover;
  object-position:top;
}

.vip-info{
  padding:18px;
  text-align:center;
}

.vip-badge{
  background:linear-gradient(135deg,#facc15,#fbbf24);
  color:#000;
  padding:6px 16px;
  border-radius:20px;
  font-size:12px;
  margin-bottom:10px;
  display:inline-block;
}

.vip-name{
  font-size:20px;
  font-weight:700;
}

.vip-jabatan{
  color:#93c5fd;
}

/* GURU */
.section-title{
  padding:10px 16px;
  font-weight:600;
}

.grid{
  display:grid;
  grid-template-columns:repeat(2,1fr);
  gap:14px;
  padding:14px;
}

.card-guru{
  background:rgba(255,255,255,.06);
  border-radius:18px;
  overflow:hidden;
}

.card-guru img{
  width:100%;
  aspect-ratio:3/4;
  object-fit:cover;
  object-position:top;
}

.info{
  padding:10px;
  text-align:center;
}

.nama{
  font-weight:600;
}

.jabatan{
  font-size:12px;
  color:#60a5fa;
}

/* ===== FOOTER PREMIUM RESPONSIVE ===== */
.footer{
  position:fixed;
  bottom:0;
  left:50%;
  transform:translateX(-50%);
  width:100%;
  max-width:430px;
  height:70px;
  backdrop-filter:blur(20px);
  background:rgba(2,6,23,0.9);
  border-top:1px solid rgba(255,255,255,.1);
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:0 6px;
  z-index:999;
  box-shadow:0 -8px 25px rgba(0,0,0,.5);
  border-top-left-radius:18px;
  border-top-right-radius:18px;
}

/* ===== MENU ===== */
.footer a{
  flex:1;
  color:#cbd5e1;
  font-size:11px;
  text-decoration:none;
  text-align:center;
  display:flex;
  flex-direction:column;
  align-items:center;
  justify-content:center;
  gap:3px;
  height:100%;
  transition:.3s ease;
  position:relative;
}

/* ICON */
.footer i{
  font-size:20px;
  transition:.3s;
}

/* HOVER */
.footer a:hover{
  color:#60a5fa;
  transform:translateY(-3px);
}

.footer a:hover i{
  transform:scale(1.15);
}

/* ACTIVE */
.footer a.active{
  color:#38bdf8;
  font-weight:600;
}

.footer a.active::after{
  content:'';
  position:absolute;
  bottom:0;
  width:40%;
  height:3px;
  background:#38bdf8;
  border-radius:3px;
}

/* ===== MOBILE KECIL ===== */
@media(max-width:360px){
  .footer{
    height:65px;
  }
  .footer i{
    font-size:18px;
  }
  .footer a{
    font-size:10px;
  }
}
</style>
</head>

<body>

<div class="phone">

<!-- HEADER -->
<div class="header">
  <img src="assets/img/logo_kiri.PNG" class="logo">
  <div class="header-title">DHARMANANDA AGUNG ACADEMY</div>
  <img src="assets/img/logo_kanan.PNG" class="logo">
</div>

<!-- KEPSEK -->
<?php if(mysqli_num_rows($kepsek)>0):
$k=mysqli_fetch_assoc($kepsek);
$foto=!empty($k['foto']) ? htmlspecialchars($k['foto']) : 'default.png';
?>
<div class="vip">
  <img src="<?= $fotoFolder.$foto ?>">
  <div class="vip-info">
    <div class="vip-badge">Kepala Sekolah</div>
    <div class="vip-name"><?= htmlspecialchars($k['nama']) ?></div>
    <div class="vip-jabatan"><?= htmlspecialchars($k['jabatan']) ?></div>
  </div>
</div>
<?php endif; ?>

<!-- GURU -->
<?php if(mysqli_num_rows($guru)>0): ?>
<div class="section-title">Guru & Tenaga Pengajar</div>

<div class="grid">
<?php while($g=mysqli_fetch_assoc($guru)):
$foto=!empty($g['foto']) ? htmlspecialchars($g['foto']) : 'default.png';
?>
<div class="card-guru">
  <img src="<?= $fotoFolder.$foto ?>">
  <div class="info">
    <div class="nama"><?= htmlspecialchars($g['nama']) ?></div>
    <div class="jabatan"><?= htmlspecialchars($g['jabatan']) ?></div>
  </div>
</div>
<?php endwhile; ?>
</div>
<?php endif; ?>

</div>

<!-- FOOTER -->
<div class="footer">
  <a href="/pkbm-test/index.html">
    <i class="bi bi-house"></i><br>Home
  </a>
  <a href="/pkbm-test/jadwal.php">
    <i class="bi bi-calendar"></i><br>Jadwal
  </a>
  <a href="/pkbm-test/chat.php">
    <i class="bi bi-chat"></i><br>Chat
  </a>
  <a href="profil_guru.php">
    <i class="bi bi-person"></i><br>Profil
  </a>
</div>

</body>
</html>