<?php
session_start();


/* ================== KONEKSI DATABASE ================== */
$conn = mysqli_connect("localhost","root","","pkbm_taruna_qurani");

if(!$conn){
    die("Koneksi database gagal");
}


/* ================== AMBIL DATA SISWA ================== */
$siswa = mysqli_fetch_assoc(mysqli_query($conn,
    "SELECT nama, kelas FROM siswa WHERE nisn='$nisn'"
));

$nama_siswa  = $siswa['nama'] ?? 'Siswa';
$kelas_siswa = $siswa['kelas'] ?? '-';
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>PKBM Taruna Qurani - App</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
*{
  box-sizing:border-box;
  font-family:'Segoe UI',system-ui,-apple-system,sans-serif
}

body{
  margin:0;
  background:linear-gradient(135deg,#f6d365,#fda085,#84fab0,#8fd3f4);
  display:flex;
  justify-content:center;
  align-items:center;
  height:100vh;
}

.phone{
  width:360px;
  height:720px;
  background:rgba(255,255,255,0.75);
  backdrop-filter:blur(20px);
  border-radius:32px;
  box-shadow:0 20px 60px rgba(0,0,0,.25);
  overflow:hidden;
  position:relative;
  border:1px solid rgba(255,255,255,.4);
}

.header{
  background:linear-gradient(135deg,#ff7e00,#ffb347);
  color:#fff;
  padding:18px;
  text-align:center;
  font-size:20px;
  font-weight:700;
  letter-spacing:.5px;
  box-shadow:0 4px 15px rgba(0,0,0,.15);
}

.subheader{
  font-size:12px;
  font-weight:500;
  margin-top:4px;
  opacity:.9;
}

.slider{
  position:relative;
  width:100%;
  aspect-ratio:16/9;
  overflow:hidden;
  background:#eee;
}

.slides{
  display:flex;
  height:100%;
  transition:transform .6s cubic-bezier(.4,0,.2,1);
}

.slide{
  flex:0 0 100%;
  height:100%;
}

.slide img{
  width:100%;
  height:100%;
  object-fit:cover;
}

.dots{
  position:absolute;
  bottom:10px;
  left:0;
  right:0;
  text-align:center;
}

.dot{
  display:inline-block;
  width:8px;
  height:8px;
  margin:0 4px;
  background:rgba(255,255,255,.5);
  border-radius:50%;
  cursor:pointer;
  transition:.3s;
}

.dot.active{
  background:#fff;
  transform:scale(1.4);
}

.menu{
  display:grid;
  grid-template-columns:repeat(3,1fr);
  gap:16px;
  padding:20px;
  padding-bottom:100px;
}

.menu a{
  text-decoration:none;
  color:#333;
}

.card{
  background:rgba(255,255,255,.85);
  border-radius:20px;
  padding:16px 10px;
  text-align:center;
  box-shadow:0 8px 20px rgba(0,0,0,.08);
  transition:.3s ease;
  backdrop-filter:blur(10px);
}

.card:hover{
  transform:translateY(-6px);
  box-shadow:0 12px 25px rgba(0,0,0,.15);
}

.card i{
  font-size:22px;
  width:48px;
  height:48px;
  line-height:48px;
  border-radius:50%;
  margin-bottom:8px;
  display:inline-block;
  background:linear-gradient(135deg,#ff7e00,#ffb347);
  color:#fff;
  box-shadow:0 4px 12px rgba(255,126,0,.4);
}

.card span{
  font-size:12px;
  font-weight:600;
  display:block;
  margin-top:4px;
}

.bottom{
  position:absolute;
  bottom:0;
  left:0;
  right:0;
  background:#fff7e6;
  border-top:1px solid #ddd;
  display:flex;
  justify-content:space-around;
  padding:10px 0;
}

.bottom a{
  text-decoration:none;
  color:#555;
  font-size:12px;
  text-align:center;
  transition:.2s;
}

.bottom i{
  display:block;
  font-size:20px;
  margin-bottom:3px;
  color:#f57c00;
}

.bottom a:hover{
  color:#000;
}
</style>
</head>

<body>
<div class="phone">

  <div class="header">
    PKBM Taruna Qurani
    <div class="subheader">
      <?= htmlspecialchars($nama_siswa) ?> | Kelas <?= htmlspecialchars($kelas_siswa) ?>
    </div>
  </div>

  <div class="slider">
    <div class="slides" id="slides">
      <div class="slide">
        <img src="assets/img/slide1.png">
      </div>
      <div class="slide">
        <img src="assets/img/slide2.png">
      </div>
      <div class="slide">
        <img src="assets/img/slide3.jpg">
      </div>
    </div>
    <div class="dots">
      <span class="dot active" onclick="goSlide(0)"></span>
      <span class="dot" onclick="goSlide(1)"></span>
      <span class="dot" onclick="goSlide(2)"></span>
    </div>
  </div>

  <div class="menu">
    <a href="presensi/login.php"><div class="card"><i class="bi bi-camera"></i><span>Presensi</span></div></a>
    <a href="ebook_guru.php"><div class="card"><i class="bi bi-book"></i><span>E-Book</span></div></a>
    <a href="edu_digital/auth/login.php"><div class="card"><i class="bi bi-laptop"></i><span>Edu Digital</span></div></a>
    <a href="smart-cbt/auth/login.php"><div class="card"><i class="bi bi-laptop"></i><span>CBT</span></div></a>
    <a href="#"><div class="card"><i class="bi bi-journal-text"></i><span>Tugas</span></div></a>
    <a href="#"><div class="card"><i class="bi bi-chat-dots"></i><span>Konsultasi</span></div></a>
    <a href="jadwal_guru.php"><div class="card"><i class="bi bi-calendar-event"></i><span>Jadwal</span></div></a>
    <a href="#"><div class="card"><i class="bi bi-patch-check"></i><span>Sertifikat</span></div></a>
    <a href="zoom_meeting.php"><div class="card"><i class="bi bi-camera-video"></i><span>Zoom Meeting</span></div></a>
  </div>

  <div class="bottom">
    <a href="index.php"><i class="bi bi-house"></i>Home</a>
    <a href="ebook_guru.php"><i class="bi bi-book"></i>E-Book</a>
    <a href="#"><i class="bi bi-chat"></i>Chat</a>
    <a href="profil_siswa.php"><i class="bi bi-person"></i>Profil</a>
  </div>

</div>

<script>
let index = 0;
const slides = document.getElementById("slides");
const dots = document.querySelectorAll(".dot");
const total = slides.children.length;

function showSlide(i){
  index = i;
  slides.style.transform = "translateX(" + (-index * 100) + "%)";
  dots.forEach(d => d.classList.remove("active"));
  if(dots[index]) dots[index].classList.add("active");
}

function goSlide(i){
  showSlide(i);
}

setInterval(() => {
  index = (index + 1) % total;
  showSlide(index);
}, 3000);
</script>

</body>
</html>
