<?php
session_start();
date_default_timezone_set("Asia/Jakarta");

$conn = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn){
    exit("ERROR");
}

/* ================= CEK LOGIN ================= */
if(empty($_SESSION['siswa_id'])){
    exit("ERROR");
}

$siswa_id = intval($_SESSION['siswa_id']);
$tanggal  = date("Y-m-d");
$jam      = date("H:i:s");
$ip       = $_SERVER['REMOTE_ADDR'] ?? '';
$device   = $_SERVER['HTTP_USER_AGENT'] ?? '';

$data = json_decode(file_get_contents("php://input"),true);

if(!$data){
    exit("ERROR");
}

$meeting_id = intval($data['meeting_id'] ?? 0);
$imageData  = $data['image'] ?? '';
$latitude   = $data['latitude'] ?? '';
$longitude  = $data['longitude'] ?? '';

if($meeting_id <= 0 || empty($imageData)){
    exit("ERROR");
}

/* ================= VALIDASI SISWA & KELAS ================= */
$qSiswa = mysqli_query($conn,"
    SELECT kelas_id FROM siswa
    WHERE id='$siswa_id'
    LIMIT 1
");

if(mysqli_num_rows($qSiswa)==0){
    exit("ERROR");
}

$siswa = mysqli_fetch_assoc($qSiswa);
$kelas_id = $siswa['kelas_id'];

/* ================= VALIDASI MEETING ================= */
$qMeet = mysqli_query($conn,"
    SELECT id, mapel_id FROM zoom_meeting
    WHERE id='$meeting_id'
    AND kelas_id='$kelas_id'
    AND status='live'
    AND NOW() BETWEEN waktu_mulai AND waktu_selesai
    LIMIT 1
");

if(mysqli_num_rows($qMeet)==0){
    exit("ERROR");
}

$meeting = mysqli_fetch_assoc($qMeet);
$mapel_id = intval($meeting['mapel_id']);

/* ================= CEK SUDAH PRESENSI ================= */
$cek = mysqli_query($conn,"
    SELECT id FROM presensi_zoom
    WHERE zoom_id='$meeting_id'
    AND siswa_id='$siswa_id'
    LIMIT 1
");

if(mysqli_num_rows($cek)>0){
    exit("ERROR"); // sudah absen
}

/* ================= SIMPAN FOTO ================= */
$folder = "../../uploads/zoom/";
if(!is_dir($folder)){
    mkdir($folder,0777,true);
}

$imageData = str_replace('data:image/png;base64,','',$imageData);
$imageData = base64_decode($imageData);

$namaFile = $folder.$siswa_id."_".time().".png";
file_put_contents($namaFile,$imageData);

/* ================= SIMPAN PRESENSI ================= */
mysqli_query($conn,"
INSERT INTO presensi_zoom
(zoom_id,siswa_id,mapel_id,tanggal,jam,foto,latitude,longitude,device_id,ip_address,created_at)
VALUES
('$meeting_id',
 '$siswa_id',
 '$mapel_id',
 '$tanggal',
 '$jam',
 '$namaFile',
 '$latitude',
 '$longitude',
 '$device',
 '$ip',
 NOW())
");

echo "OK";
?>
