<?php
session_start();
require '../config/database.php';

if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

$id         = (int)($_POST['id'] ?? 0);
$pertanyaan = trim($_POST['pertanyaan'] ?? '');
$tipe       = $_POST['tipe'] ?? '';

if(!$id || !$pertanyaan) die('Data tidak lengkap');

/* UPDATE SOAL */
$stmt = $conn->prepare("UPDATE materi_soal SET pertanyaan=? WHERE id=?");
$stmt->bind_param("si",$pertanyaan,$id);
$stmt->execute();

/* HAPUS OPSI LAMA */
mysqli_query($conn,"DELETE FROM materi_soal_opsi WHERE soal_id=$id");

/* ================= PG ================= */
if($tipe=='pg'){

  $opsi  = $_POST['opsi'] ?? [];
  $benar = (int)($_POST['benar'] ?? -1);

  foreach($opsi as $i=>$teks){
    $isBenar = ($i==$benar)?1:0;

    $stmt=$conn->prepare("INSERT INTO materi_soal_opsi(soal_id,opsi,benar) VALUES(?,?,?)");
    $stmt->bind_param("isi",$id,$teks,$isBenar);
    $stmt->execute();
  }
}

/* ================= BS ================= */
if($tipe=='bs'){

  $jawaban = $_POST['jawaban_bs'] ?? '';

  foreach(['Benar','Salah'] as $opsi){
    $isBenar = ($jawaban==$opsi)?1:0;

    $stmt=$conn->prepare("INSERT INTO materi_soal_opsi(soal_id,opsi,benar) VALUES(?,?,?)");
    $stmt->bind_param("isi",$id,$opsi,$isBenar);
    $stmt->execute();
  }
}

/* ================= ISIAN / ESSAY ================= */
if($tipe=='isian' || $tipe=='essay'){

  $jawaban = trim($_POST['jawaban'] ?? '');

  if($jawaban!=''){
    $stmt=$conn->prepare("INSERT INTO materi_soal_opsi(soal_id,opsi,benar) VALUES(?,?,1)");
    $stmt->bind_param("is",$id,$jawaban);
    $stmt->execute();
  }
}

echo "OK";
