<?php
session_start();
require '../config/database.php';

/* ================= SECURITY TUTOR ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    header('Location: ../auth/login.php');
    exit;
}

$tutor_id = (int)$_SESSION['user']['id'];
$nama     = $_SESSION['user']['nama'];

/* ================= TAHUN AJARAN AKTIF ================= */
$qta = mysqli_query($conn,"SELECT id,tahun FROM tahun_ajaran WHERE status='aktif' LIMIT 1");
$tahun = mysqli_fetch_assoc($qta);
if(!$tahun){ die('Tahun ajaran belum aktif'); }
$tahun_id   = (int)$tahun['id'];
$tahun_nama = $tahun['tahun'];

/* ================= DATA MATERI ================= */
$q = mysqli_query($conn,"
 SELECT 
   m.id,m.judul,m.tipe,m.file,mp.nama_mapel,
   COUNT(DISTINCT mb.id) AS total_baca,
   COUNT(DISTINCT mb.siswa_id) AS siswa_baca,
   MAX(mb.dibaca_pada) AS terakhir_baca
 FROM materi m
 JOIN materi_kelas mk ON mk.materi_id=m.id
 JOIN kelas k ON k.id=mk.kelas_id
 LEFT JOIN mapel mp ON mp.id=m.mapel_id
 LEFT JOIN materi_baca mb ON mb.materi_id=m.id
 WHERE m.tutor_id=$tutor_id AND k.tahun_id=$tahun_id
 GROUP BY m.id
 ORDER BY m.created_at DESC
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>E-Learning Tutor</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:80px 20px;transition:.3s}
@media(max-width:991px){
 .main-content{margin-left:0;padding-top:70px}
}

/* ===== TOPBAR MOBILE ===== */
.topbar{
 display:none;
}
@media(max-width:991px){
 .topbar{
  display:flex;
  align-items:center;
  gap:10px;
  background:#0d6efd;
  color:#fff;
  padding:10px 14px;
  position:fixed;
  top:0;
  left:0;
  right:0;
  z-index:1050;
 }
}

/* ===== CARD ===== */
.card{
 border-radius:18px;
 box-shadow:0 6px 18px rgba(0,0,0,.08)
}
/* ================= OFFCANVAS FIX ================= */
.offcanvas{
 z-index:1600;
}

/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<!-- ===== TOPBAR MOBILE ===== -->
<div class="topbar d-lg-none">
 <button class="btn btn-light btn-sm"
  data-bs-toggle="offcanvas"
  data-bs-target="#sidebarTutor">
  <i class="bi bi-list"></i>
 </button>
 <b>E-Learning Tutor</b>
</div>

<!-- ===== SIDEBAR ===== -->
<?php include 'sidebar.php'; ?>

<div class="main-content container-fluid">

<div class="card p-4">

<div class="d-flex justify-content-between align-items-center mb-3">
 <h6 class="mb-0"><i class="bi bi-mortarboard"></i> E-Learning Tutor</h6>
 <span class="small text-muted">Tahun <?= htmlspecialchars($tahun_nama) ?></span>
</div>

<div class="table-responsive">
<table class="table table-bordered table-hover align-middle small">
<thead class="table-dark text-center">
<tr>
 <th>Judul Materi</th>
 <th>Mapel</th>
 <th>Tipe</th>
 <th>Total Dibaca</th>
 <th>Siswa Membaca</th>
 <th>Terakhir Dibaca</th>
 <th>Detail</th>
</tr>
</thead>
<tbody>

<?php if(!mysqli_num_rows($q)): ?>
<tr>
 <td colspan="7" class="text-center text-muted">
  Belum ada materi
 </td>
</tr>
<?php endif; ?>

<?php while($d=mysqli_fetch_assoc($q)): ?>
<tr>
 <td><?= htmlspecialchars($d['judul']) ?></td>
 <td><?= htmlspecialchars($d['nama_mapel']) ?></td>
 <td class="text-center">
  <span class="badge <?= $d['tipe']=='pdf'?'bg-danger':'bg-success' ?>">
   <?= strtoupper($d['tipe']) ?>
  </span>
 </td>
 <td class="text-center fw-semibold"><?= (int)$d['total_baca'] ?></td>
 <td class="text-center"><?= (int)$d['siswa_baca'] ?></td>
 <td class="text-center">
  <?= $d['terakhir_baca'] ? date('d/m/Y H:i',strtotime($d['terakhir_baca'])) : '-' ?>
 </td>
 <td class="text-center">
  <a href="elearning_detail.php?id=<?= $d['id'] ?>" class="btn btn-outline-primary btn-sm">
   <i class="bi bi-eye"></i>
  </a>
 </td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
