<?php 
session_start();
require '../config/database.php';

/* ================= PROTEKSI LOGIN ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    header("Location: login_siswa.php");
    exit;
}

$siswa_id = $_SESSION['siswa']['id'];
$nama     = $_SESSION['siswa']['nama'];
$kelas_id = $_SESSION['siswa']['kelas_id'];

/* ================= DATA SISWA ================= */
$qs = mysqli_query($conn,"
 SELECT 
  s.*,
  k.nama_kelas,
  p.nama AS nama_paket
FROM siswa s
LEFT JOIN kelas k ON k.id = s.kelas_id
LEFT JOIN paket p ON p.id = k.paket_id
WHERE s.id = '$siswa_id'
LIMIT 1

");
$siswa = mysqli_fetch_assoc($qs);

$nama_kelas = $siswa['nama_kelas'] ?? '-';
$nama_paket = $siswa['nama_paket'] ?? '-';

$foto = !empty($siswa['foto'])
        ? "../uploads/siswa/".$siswa['foto']
        : "../assets/user.png";

/* ================= FORMAT KELAS ================= */
function formatKelasPaket($kelas, $paket){
  if(!$kelas || !$paket) return '-';
  return "Kelas $kelas Paket $paket";
}

/* ================= HITUNG JUMLAH ================= */

/* ===== UJIAN ===== */
$q_ujian = mysqli_query($conn,"
 SELECT COUNT(DISTINCT u.id) total
 FROM ujian u
 JOIN kelas_mengajar km ON km.mapel_id = u.mapel_id
 WHERE km.kelas_id = '$kelas_id'
");
$jml_ujian = (int)(mysqli_fetch_assoc($q_ujian)['total'] ?? 0);

/* ===== MATERI / ELEARNING ===== */
$q_materi = mysqli_query($conn,"
 SELECT COUNT(*) total
 FROM materi_kelas
 WHERE kelas_id = '$kelas_id'
");
$jml_materi   = (int)(mysqli_fetch_assoc($q_materi)['total'] ?? 0);
$jml_elearing = $jml_materi;

/* ===== ABSEN ===== */
$q_absen = mysqli_query($conn,"
 SELECT COUNT(DISTINCT tanggal) total
 FROM presensi
 WHERE siswa_id = '$siswa_id'
");
$jml_absen = (int)(mysqli_fetch_assoc($q_absen)['total'] ?? 0);
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
 background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
 min-height:100vh;
 display:flex;
 flex-direction:column;
 font-family:system-ui;
}

/* ===== PROFIL ===== */
.profile-box{
 background:#fff;
 border-radius:18px;
 padding:16px;
 box-shadow:0 5px 20px rgba(0,0,0,.08);
}
.profile-box img{
 width:72px;
 height:72px;
 object-fit:cover;
 border-radius:50%;
 border:3px solid #0d6efd;
}
.profile-name{font-weight:600}
.profile-kelas{font-size:.85rem;color:#6c757d}

/* ===== CARD MENU ===== */
.card-menu{border-radius:18px;transition:.3s}
.card-menu:hover{
 transform:translateY(-4px);
 box-shadow:0 12px 28px rgba(0,0,0,.12);
}
.icon-box{
 width:60px;
 height:60px;
 border-radius:16px;
 display:flex;
 align-items:center;
 justify-content:center;
 margin:auto;
}

/* ===== FOOTER NAV ===== */
.footer-nav{
 position:fixed;
 bottom:0;
 left:0;
 right:0;
 background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
 border-top:1px solid #ddd;
 display:flex;
 justify-content:space-around;
 padding:8px 0;
 z-index:999;
}
.footer-nav a{
 text-decoration:none;
 color:#666;
 font-size:12px;
 text-align:center;
}
.footer-nav i{
 font-size:20px;
 display:block;
}
.footer-space{height:70px}

/* ===== MOBILE ===== */
@media (max-width:576px){
 .profile-box img{width:64px;height:64px}
}
</style>
</head>
<body>

<!-- ================= MODAL PROFIL ================= -->
<div class="modal fade" id="modalProfil">
 <div class="modal-dialog modal-dialog-centered">
  <div class="modal-content rounded-4 shadow">

   <div class="modal-header border-0">
    <h6 class="modal-title fw-bold">
     <i class="bi bi-person-circle"></i> Profil Siswa
    </h6>
    <button class="btn-close" data-bs-dismiss="modal"></button>
   </div>

   <div class="modal-body text-center">
    <img src="<?= $foto ?>" class="rounded-circle mb-3"
         style="width:90px;height:90px;object-fit:cover;border:4px solid #0d6efd">
    <div class="fw-bold"><?= htmlspecialchars($nama) ?></div>
    <div class="text-muted small mb-2">
      <?= formatKelasPaket($nama_kelas, $nama_paket) ?>
    </div>

    <hr>

    <form method="post" action="profil_password.php">
     <input type="password" name="old_password" class="form-control mb-2" placeholder="Password Lama" required>
     <input type="password" name="new_password" class="form-control mb-2" placeholder="Password Baru" required>
     <input type="password" name="confirm_password" class="form-control mb-2" placeholder="Konfirmasi Password" required>
     <button class="btn btn-primary w-100">
      <i class="bi bi-key"></i> Ganti Password
     </button>
    </form>
   </div>

   <div class="modal-footer border-0">
    <a href="../auth/logout_siswa.php" class="btn btn-danger w-100">

     <i class="bi bi-box-arrow-right"></i> Logout
    </a>
   </div>

  </div>
 </div>
</div>

<!-- ================= NAVBAR ================= -->
<nav class="navbar navbar-dark bg-primary shadow">
 <div class="container-fluid">
  <span class="navbar-brand fw-bold">
   <i class="bi bi-mortarboard-fill"></i> PKBM TARUNA QURANI
  </span>
 </div>
</nav>

<div class="container mt-4 mb-4">

<div class="profile-box mb-4">
 <div class="d-flex align-items-center gap-3">
  <img src="<?= $foto ?>">
  <div>
   <div class="profile-name"><?= htmlspecialchars($nama) ?></div>
   <div class="profile-kelas">
    <?= formatKelasPaket($nama_kelas, $nama_paket) ?>
   </div>
  </div>
 </div>
</div>

<!-- ================= MENU ================= -->
<div class="row g-3">
<?php
$menu = [
 ['Absen','danger','bi bi-camera',$jml_absen,'absen_list.php'],
 ['Materi','warning','book-half',$jml_materi,'materi.php'],
 ['E-Learning','success','laptop',$jml_elearing,'elearning.php'],
 ['Ujian','primary','journal-check',$jml_ujian,'ujian.php']
];
foreach($menu as $m):
?>
<div class="col-6 col-md-3">
 <div class="card card-menu">
  <div class="card-body text-center">
   <div class="icon-box bg-<?= $m[1] ?> text-white mb-2">
    <i class="bi bi-<?= $m[2] ?>"></i>
   </div>
   <h6><?= $m[0] ?></h6>
   <div class="fw-bold"><?= $m[3] ?></div>
   <a href="<?= $m[4] ?>" class="btn btn-<?= $m[1] ?> w-100 mt-2">Masuk</a>
  </div>
 </div>
</div>
<?php endforeach; ?>
</div>
</div>

<!-- ================= FOOTER ================= -->
<div class="footer-nav">
 <a href="#" data-bs-toggle="modal" data-bs-target="#modalProfil">
  <i class="bi bi-person-circle"></i> Profil
 </a>
 <a href="absen_list.php"><i class="bi bi-camera"></i>Absen</a>
 <a href="materi.php"><i class="bi bi-book"></i>Materi</a>
 <a href="elearning.php"><i class="bi bi-laptop"></i>E-Learning</a>
 <a href="#"><i class="bi bi-journal-check"></i>Ujian</a>
</div>

<div class="footer-space"></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
