<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
  empty($_SESSION['login_siswa']) ||
  empty($_SESSION['siswa']['id'])
) {
  header("Location: login_siswa.php");
  exit;
}

$siswa_id = (int)$_SESSION['siswa']['id'];
$kelas_id = (int)$_SESSION['siswa']['kelas_id'];
$nama     = $_SESSION['siswa']['nama'];

$mapel_id = (int)($_GET['mapel_id'] ?? 0);
if(!$mapel_id){
  die('Mapel tidak valid');
}

/* ================= CEK MAPEL ================= */
$qm = mysqli_query($conn,"
 SELECT m.nama_mapel
 FROM mapel m
 JOIN kelas_mengajar km ON km.mapel_id=m.id
 WHERE m.id=$mapel_id AND km.kelas_id=$kelas_id
 LIMIT 1
");
$mapel = mysqli_fetch_assoc($qm);
if(!$mapel){
  die('Mapel tidak ditemukan');
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Absen Kehadiran</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#eef2f7}
.card{border-radius:18px}
video,canvas,img{width:100%;border-radius:12px}
</style>
</head>
<body>

<div class="container py-4">

<h4 class="fw-bold mb-3">
<i class="bi bi-camera-fill"></i> Absen Mapel
</h4>

<div class="alert alert-primary">
<b><?= htmlspecialchars($mapel['nama_mapel']) ?></b>
</div>

<form method="post" action="absen_simpan.php" class="card p-3 shadow-sm">

<input type="hidden" name="mapel_id" value="<?= $mapel_id ?>">
<input type="hidden" name="latitude" id="latitude">
<input type="hidden" name="longitude" id="longitude">
<input type="hidden" name="foto" id="foto">

<!-- KAMERA -->
<div class="mb-3">
<label class="fw-semibold">Foto Selfie</label>
<video id="video" autoplay playsinline></video>
<canvas id="canvas" class="d-none"></canvas>

<button type="button" id="btnCapture" class="btn btn-primary w-100 mt-2">
<i class="bi bi-camera"></i> Ambil Foto
</button>

<img id="preview" class="mt-2 d-none">
</div>

<!-- LOKASI -->
<div class="mb-3">
<label class="fw-semibold">Lokasi</label>
<div class="alert alert-info py-2" id="lokasiText">
Mendeteksi lokasi...
</div>
</div>

<button class="btn btn-success w-100">
<i class="bi bi-check-circle"></i> Kirim Absen
</button>

</form>

</div>

<script>
const video = document.getElementById('video');
const canvas = document.getElementById('canvas');
const preview = document.getElementById('preview');
const fotoInput = document.getElementById('foto');

navigator.mediaDevices.getUserMedia({
 video:{ facingMode:"user" },
 audio:false
}).then(stream=>{
 video.srcObject = stream;
});

document.getElementById('btnCapture').onclick = ()=>{
 canvas.width = video.videoWidth;
 canvas.height = video.videoHeight;
 canvas.getContext('2d').drawImage(video,0,0);
 const data = canvas.toDataURL('image/jpeg');
 fotoInput.value = data;
 preview.src = data;
 preview.classList.remove('d-none');
};

navigator.geolocation.getCurrentPosition(pos=>{
 document.getElementById('latitude').value = pos.coords.latitude;
 document.getElementById('longitude').value = pos.coords.longitude;
 document.getElementById('lokasiText').innerHTML = '📍 Lokasi terdeteksi';
},()=>{
 document.getElementById('lokasiText').innerHTML = '❌ Lokasi tidak tersedia';
});
</script>

</body>
</html>
