CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100) NOT NULL,
    username VARCHAR(50) UNIQUE,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin','tutor','siswa') NOT NULL,
    status ENUM('aktif','nonaktif') DEFAULT 'aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE pkbm (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_pkbm VARCHAR(150),
    npsn VARCHAR(20),
    alamat TEXT,
    kepala_pkbm VARCHAR(100)
);
CREATE TABLE tahun_ajaran (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tahun VARCHAR(20),
    status ENUM('aktif','nonaktif') DEFAULT 'nonaktif'
);
CREATE TABLE paket (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama ENUM('A','B','C') UNIQUE
);
CREATE TABLE kelas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_kelas VARCHAR(50),
    paket_id INT,
    tahun_id INT,
    FOREIGN KEY (paket_id) REFERENCES paket(id),
    FOREIGN KEY (tahun_id) REFERENCES tahun_ajaran(id)
);
CREATE TABLE siswa (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    nis VARCHAR(30) UNIQUE,
    kelas_id INT,
    jenis_kelamin ENUM('L','P'),
    tanggal_lahir DATE,
    alamat TEXT,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (kelas_id) REFERENCES kelas(id)
);
CREATE TABLE tutor (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    pendidikan VARCHAR(100),
    FOREIGN KEY (user_id) REFERENCES users(id)
);
CREATE TABLE mapel (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_mapel VARCHAR(100),
    paket_id INT,
    FOREIGN KEY (paket_id) REFERENCES paket(id)
);
CREATE TABLE materi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mapel_id INT,
    tutor_id INT,
    judul VARCHAR(150),
    tipe ENUM('pdf','video','audio','teks'),
    file VARCHAR(255),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (mapel_id) REFERENCES mapel(id),
    FOREIGN KEY (tutor_id) REFERENCES tutor(id)
);
CREATE TABLE ujian (
    id INT AUTO_INCREMENT PRIMARY KEY,
    mapel_id INT,
    nama_ujian VARCHAR(100),
    durasi INT COMMENT 'menit',
    tanggal DATE,
    FOREIGN KEY (mapel_id) REFERENCES mapel(id)
);
CREATE TABLE soal (
    id INT AUTO_INCREMENT PRIMARY KEY,
    ujian_id INT,
    pertanyaan TEXT,
    jenis ENUM('pg','essay'),
    FOREIGN KEY (ujian_id) REFERENCES ujian(id)
);
CREATE TABLE pilihan_jawaban (
    id INT AUTO_INCREMENT PRIMARY KEY,
    soal_id INT,
    pilihan CHAR(1),
    jawaban TEXT,
    benar ENUM('Y','N'),
    FOREIGN KEY (soal_id) REFERENCES soal(id)
);
CREATE TABLE jawaban_siswa (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT,
    soal_id INT,
    jawaban TEXT,
    FOREIGN KEY (siswa_id) REFERENCES siswa(id),
    FOREIGN KEY (soal_id) REFERENCES soal(id)
);
CREATE TABLE nilai (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT,
    ujian_id INT,
    nilai FLOAT,
    FOREIGN KEY (siswa_id) REFERENCES siswa(id),
    FOREIGN KEY (ujian_id) REFERENCES ujian(id)
);
CREATE TABLE presensi (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT,
    tanggal DATE,
    status ENUM('hadir','izin','alpha'),
    FOREIGN KEY (siswa_id) REFERENCES siswa(id)
);
CREATE TABLE rapor (
    id INT AUTO_INCREMENT PRIMARY KEY,
    siswa_id INT,
    mapel_id INT,
    nilai_akhir FLOAT,
    semester ENUM('1','2'),
    FOREIGN KEY (siswa_id) REFERENCES siswa(id),
    FOREIGN KEY (mapel_id) REFERENCES mapel(id)
);
INSERT INTO paket (nama) VALUES ('A'),('B'),('C');

INSERT INTO tahun_ajaran (tahun,status)
VALUES ('2025/2026','aktif');

INSERT INTO users (nama,username,password,role)
VALUES ('Admin PKBM','admin',MD5('123456'),'admin');
