<?php
session_start();
require '../config/database.php';
require '../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    die('Akses ditolak');
}

/* ================= PARAMETER ================= */
$kelas_id = (int)($_GET['kelas_id'] ?? 0);
$mapel_id = (int)($_GET['mapel_id'] ?? 0);
$tutor_id = (int)($_GET['tutor_id'] ?? 0);
$mode     = $_GET['mode'] ?? 'harian';
$tgl1     = $_GET['tgl1'] ?? date('Y-m-d');
$tgl2     = $_GET['tgl2'] ?? $tgl1;

/* ================= RANGE TANGGAL ================= */
if ($mode === 'harian') {
    $awal = $akhir = $tgl1;
} elseif ($mode === 'mingguan') {
    $awal  = date('Y-m-d', strtotime('monday this week', strtotime($tgl1)));
    $akhir = date('Y-m-d', strtotime('sunday this week', strtotime($tgl1)));
} elseif ($mode === 'bulanan') {
    $awal  = date('Y-m-01', strtotime($tgl1));
    $akhir = date('Y-m-t', strtotime($tgl1));
} else {
    $awal  = $tgl1;
    $akhir = $tgl2;
}

/* ================= WHERE ================= */
$where = "WHERE 1=1";
if($kelas_id) $where .= " AND k.id='$kelas_id'";
if($mapel_id) $where .= " AND mp.id='$mapel_id'";
if($tutor_id) $where .= " AND t.id='$tutor_id'";

/* ================= INFO HEADER ================= */
$qInfo = mysqli_query($conn,"
 SELECT 
   k.nama_kelas,
   p.nama AS paket,
   mp.nama_mapel,
   t.nama AS nama_tutor
 FROM presensi pr
 JOIN siswa s ON s.id = pr.siswa_id
 JOIN kelas k ON k.id = s.kelas_id
 LEFT JOIN paket p ON p.id = k.paket_id
 JOIN mapel mp ON mp.id = pr.mapel_id
 JOIN kelas_mengajar km 
   ON km.kelas_id = k.id 
  AND km.mapel_id = mp.id
 JOIN tutor t ON t.id = km.tutor_id
 $where
 LIMIT 1
");

$info = mysqli_fetch_assoc($qInfo);

/* ================= DATA PRESENSI ================= */
$q = mysqli_query($conn,"
 SELECT 
   s.nama,
   SUM(pr.status='hadir') AS hadir,
   SUM(pr.status='izin') AS izin,
   SUM(pr.status='sakit') AS sakit,
   SUM(pr.status IN ('alfa','alpa')) AS alpa,
   COUNT(pr.id) AS total
 FROM siswa s
 LEFT JOIN presensi pr
   ON pr.siswa_id=s.id
  AND pr.tanggal BETWEEN '$awal' AND '$akhir'
  ".($mapel_id ? "AND pr.mapel_id=$mapel_id" : "")."
 WHERE 1=1
 ".($kelas_id ? "AND s.kelas_id=$kelas_id" : "")."
 GROUP BY s.id
 ORDER BY s.nama
");

/* ================= HTML ================= */
$html = '
<style>
body{font-family:DejaVu Sans;font-size:11px}
h2{text-align:center;margin:0}
table{width:100%;border-collapse:collapse;margin-top:10px}
th,td{border:1px solid #000;padding:5px;text-align:center}
th{background:#f2f2f2}
.left{text-align:left}
.h{background:#c6efce}
.i{background:#fff2cc}
.s{background:#ddebf7}
.a{background:#f8cbad}
.info td{border:none;padding:2px;font-size:11px}
.label{width:70px;text-align:left}
.colon{width:8px;text-align:center}
.value{text-align:left}
</style>

<h2>PKBM TARUNA QURANI</h2>
<div style="text-align:center;margin-bottom:6px">
Rekap Presensi Siswa (Admin)
</div>

<table class="info">
<tr>
  <td class="label">Kelas</td><td class="colon">:</td>
  <td class="value">'.($info['nama_kelas'] ?? '-').($info['paket'] ? ' - '.$info['paket'] : '').'</td>
</tr>
<tr>
  <td class="label">Mapel</td><td class="colon">:</td>
  <td class="value">'.($info['nama_mapel'] ?? 'Semua').'</td>
</tr>
<tr>
  <td class="label">Tutor</td><td class="colon">:</td>
  <td class="value">'.($info['nama_tutor'] ?? 'Semua').'</td>
</tr>
<tr>
  <td class="label">Periode</td><td class="colon">:</td>
  <td class="value">'.date('d-m-Y',strtotime($awal)).' s/d '.date('d-m-Y',strtotime($akhir)).'</td>
</tr>
</table>

<table>
<tr>
<th>No</th>
<th>Nama</th>
<th>H</th>
<th>I</th>
<th>S</th>
<th>A</th>
<th>Total</th>
<th>%</th>
<th>Keterangan</th>
</tr>
';

$no = 1;
while($r=mysqli_fetch_assoc($q)){
 $total = max(1,$r['total']);
 $persen = round(($r['hadir']/$total)*100);
 $ket = $persen>=90?'Sangat Aktif':($persen>=75?'Aktif':($persen>=60?'Cukup':'Kurang'));

 $html .= "
 <tr>
  <td>$no</td>
  <td class='left'>{$r['nama']}</td>
  <td class='h'>{$r['hadir']}</td>
  <td class='i'>{$r['izin']}</td>
  <td class='s'>{$r['sakit']}</td>
  <td class='a'>{$r['alpa']}</td>
  <td>$total</td>
  <td>{$persen}%</td>
  <td>$ket</td>
 </tr>";
 $no++;
}

$html .= '</table>';

/* ================= GENERATE PDF ================= */
$options = new Options();
$options->set('defaultFont','DejaVu Sans');

$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4','portrait');
$dompdf->render();
$dompdf->stream("Rekap_Presensi_Admin.pdf",["Attachment"=>false]);
