<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= VALIDASI ================= */
$aksi = $_POST['aksi'] ?? '';

if (!in_array($aksi, ['tambah','edit','hapus'])) {
    header("Location: mapel.php");
    exit;
}

/* ================= TAMBAH MAPEL ================= */
if ($aksi === 'tambah') {

    $nama = trim($_POST['nama_mapel'] ?? '');
    $max  = (int)($_POST['max_materi'] ?? 0);

    if ($nama === '') {
        header("Location: mapel.php");
        exit;
    }

    // Cegah duplikat mapel
    $cek = mysqli_query($conn,"
        SELECT id FROM mapel 
        WHERE nama_mapel='".mysqli_real_escape_string($conn,$nama)."'
        LIMIT 1
    ");

    if (mysqli_num_rows($cek)) {
        header("Location: mapel.php?duplikat=1");
        exit;
    }

    mysqli_query($conn,"
        INSERT INTO mapel (nama_mapel, max_materi)
        VALUES (
            '".mysqli_real_escape_string($conn,$nama)."',
            $max
        )
    ");

    header("Location: mapel.php?sukses=tambah");
    exit;
}

/* ================= EDIT MAPEL ================= */
if ($aksi === 'edit') {

    $id   = (int)($_POST['id'] ?? 0);
    $nama = trim($_POST['nama_mapel'] ?? '');
    $max  = (int)($_POST['max_materi'] ?? 0);

    if ($id <= 0 || $nama === '') {
        header("Location: mapel.php");
        exit;
    }

    mysqli_query($conn,"
        UPDATE mapel SET
            nama_mapel='".mysqli_real_escape_string($conn,$nama)."',
            max_materi=$max
        WHERE id=$id
        LIMIT 1
    ");

    header("Location: mapel.php?sukses=edit");
    exit;
}

/* ================= HAPUS MAPEL ================= */
if ($aksi === 'hapus') {

    $id = (int)($_POST['id'] ?? 0);
    if ($id <= 0) {
        header("Location: mapel.php");
        exit;
    }

    // Cegah hapus jika masih dipakai materi
    $cekMateri = mysqli_query($conn,"
        SELECT id FROM materi WHERE mapel_id=$id LIMIT 1
    ");

    if (mysqli_num_rows($cekMateri)) {
        header("Location: mapel.php?gagal=relasi");
        exit;
    }

    mysqli_query($conn,"
        DELETE FROM mapel WHERE id=$id LIMIT 1
    ");

    header("Location: mapel.php?sukses=hapus");
    exit;
}

header("Location: mapel.php");
exit;
